/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.value.WritableValue;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteImageLoader {
    private final Map<URI, WeakReference<Image>> cache = new HashMap<URI, WeakReference<Image>>();
    private final Map<URI, List<WeakReference<WritableValue<Image>>>> pendingRequests = new HashMap<URI, List<WeakReference<WritableValue<Image>>>>();
    private final WeakHashMap<WritableValue<Image>, URI> reverseLookup = new WeakHashMap();

    @Nullable
    protected Image getPlaceholder() {
        return null;
    }

    @NotNull
    protected abstract Task<Image> createLoadTask(@NotNull URI var1);

    public void load(@NotNull WritableValue<Image> writableValue, String url) {
        URI uri = NetworkUtils.toURIOrNull(url);
        if (uri == null) {
            this.reverseLookup.remove(writableValue);
            writableValue.setValue((Object)this.getPlaceholder());
            return;
        }
        WeakReference<Image> reference = this.cache.get(uri);
        if (reference != null) {
            Image image = (Image)reference.get();
            if (image != null) {
                this.reverseLookup.remove(writableValue);
                writableValue.setValue((Object)image);
                return;
            }
            this.cache.remove(uri);
        }
        writableValue.setValue((Object)this.getPlaceholder());
        List<WeakReference<WritableValue<Image>>> list = this.pendingRequests.get(uri);
        if (list != null) {
            list.add(new WeakReference<WritableValue<Image>>(writableValue));
            this.reverseLookup.put(writableValue, uri);
            return;
        }
        list = new ArrayList<WeakReference<WritableValue<Image>>>(1);
        list.add(new WeakReference<WritableValue<Image>>(writableValue));
        this.pendingRequests.put(uri, list);
        this.reverseLookup.put(writableValue, uri);
        this.createLoadTask(uri).whenComplete(Schedulers.javafx(), (result, exception) -> {
            Image image;
            if (exception == null) {
                image = result;
            } else {
                Logger.LOG.warning("Failed to load image from " + String.valueOf(uri), exception);
                image = this.getPlaceholder();
            }
            this.cache.put(uri, new WeakReference<Image>(image));
            List<WeakReference<WritableValue<Image>>> list = this.pendingRequests.remove(uri);
            if (list != null) {
                for (WeakReference<WritableValue<Image>> ref : list) {
                    WritableValue target = (WritableValue)ref.get();
                    if (target == null || !uri.equals(this.reverseLookup.get(target))) continue;
                    this.reverseLookup.remove(target);
                    target.setValue((Object)image);
                }
            }
        }).start();
    }

    public void unload(@NotNull WritableValue<Image> writableValue) {
        this.reverseLookup.remove(writableValue);
    }

    public void clearInvalidCache() {
        this.cache.entrySet().removeIf(entry -> ((WeakReference)entry.getValue()).get() == null);
    }
}

