/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.function.ExceptionalSupplier;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheRepository {
    private Path commonDirectory;
    private Path cacheDirectory;
    private Path indexFile;
    private FileTime indexFileLastModified;
    private LinkedHashMap<URI, ETagItem> index;
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Pattern MAX_AGE = Pattern.compile("(s-maxage|max-age)=(?<time>[0-9]+)");
    private static CacheRepository instance = new CacheRepository();
    public static final String SHA1 = "SHA-1";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDirectory(Path commonDir) {
        block18: {
            this.commonDirectory = commonDir;
            this.cacheDirectory = commonDir.resolve("cache");
            this.indexFile = this.cacheDirectory.resolve("etag.json");
            this.lock.writeLock().lock();
            try {
                if (Files.isRegularFile(this.indexFile, new LinkOption[0])) {
                    try (FileChannel channel = FileChannel.open(this.indexFile, StandardOpenOption.READ);
                         FileLock lock = channel.tryLock(0L, Long.MAX_VALUE, true);){
                        FileTime lastModified = Lang.ignoringException(() -> Files.getLastModifiedTime(this.indexFile, new LinkOption[0]));
                        ETagIndex raw = JsonUtils.GSON.fromJson((Reader)new BufferedReader(Channels.newReader((ReadableByteChannel)channel, StandardCharsets.UTF_8)), ETagIndex.class);
                        this.index = raw != null ? this.joinETagIndexes(raw.eTag) : new LinkedHashMap();
                        this.indexFileLastModified = lastModified;
                        break block18;
                    }
                }
                this.index = new LinkedHashMap();
                this.indexFileLastModified = null;
            }
            catch (Exception e) {
                Logger.LOG.warning("Unable to read index file", e);
                this.index = new LinkedHashMap();
                this.indexFileLastModified = null;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    public Path getCommonDirectory() {
        return this.commonDirectory;
    }

    public Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    protected Path getFile(String algorithm, String hash) {
        hash = hash.toLowerCase(Locale.ROOT);
        return this.getCacheDirectory().resolve(algorithm).resolve(hash.substring(0, 2)).resolve(hash);
    }

    protected boolean fileExists(String algorithm, String hash) {
        if (hash == null) {
            return false;
        }
        Path file = this.getFile(algorithm, hash);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return DigestUtils.digestToString(algorithm, file).equalsIgnoreCase(hash);
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    public void tryCacheFile(Path path, String algorithm, String hash) throws IOException {
        Path cache = this.getFile(algorithm, hash);
        if (Files.isRegularFile(cache, new LinkOption[0])) {
            return;
        }
        FileUtils.copyFile(path, cache);
    }

    public Path cacheFile(Path path, String algorithm, String hash) throws IOException {
        Path cache = this.getFile(algorithm, hash);
        FileUtils.copyFile(path, cache);
        return cache;
    }

    public Optional<Path> checkExistentFile(@Nullable Path original, String algorithm, String hash) {
        if (this.fileExists(algorithm, hash)) {
            return Optional.of(this.getFile(algorithm, hash));
        }
        if (original != null && Files.exists(original, new LinkOption[0])) {
            if (hash != null) {
                try {
                    String checksum = DigestUtils.digestToString(algorithm, original);
                    if (checksum.equalsIgnoreCase(hash)) {
                        return Optional.of(this.restore(original, () -> this.cacheFile(original, algorithm, hash)));
                    }
                }
                catch (IOException iOException) {}
            } else {
                return Optional.of(original);
            }
        }
        return Optional.empty();
    }

    protected Path restore(Path original, ExceptionalSupplier<Path, ? extends IOException> cacheSupplier) throws IOException {
        Path cache = cacheSupplier.get();
        Files.delete(original);
        Files.createLink(original, cache);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getCachedRemoteFile(URI uri, boolean checkExpires) throws IOException {
        String hash;
        ETagItem eTagItem;
        this.lock.readLock().lock();
        try {
            eTagItem = this.index.get(NetworkUtils.dropQuery(uri));
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (eTagItem == null) {
            throw new IOException("Cannot find the URL");
        }
        if (StringUtils.isBlank(eTagItem.hash) || !this.fileExists(SHA1, eTagItem.hash)) {
            throw new FileNotFoundException();
        }
        if (checkExpires && System.currentTimeMillis() > eTagItem.expires) {
            throw new CacheExpiredException(eTagItem.expires);
        }
        Path file = this.getFile(SHA1, eTagItem.hash);
        if (Files.getLastModifiedTime(file, new LinkOption[0]).toMillis() != eTagItem.localLastModified && !Objects.equals(hash = DigestUtils.digestToString(SHA1, file), eTagItem.hash)) {
            throw new IOException("This file is modified");
        }
        return file;
    }

    public void removeRemoteEntry(URI uri) {
        this.lock.writeLock().lock();
        try {
            this.index.remove(NetworkUtils.dropQuery(uri));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @NotNull
    public Map<String, String> injectConnection(URI uri) {
        ETagItem eTagItem;
        try {
            uri = NetworkUtils.dropQuery(uri);
        }
        catch (IllegalArgumentException e) {
            return Map.of();
        }
        this.lock.readLock().lock();
        try {
            eTagItem = this.index.get(uri);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (eTagItem == null) {
            return Map.of();
        }
        if (eTagItem.eTag != null) {
            return Map.of("if-none-match", eTagItem.eTag);
        }
        return Map.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void injectConnection(URI uri, HttpRequest.Builder requestBuilder) {
        ETagItem eTagItem;
        try {
            uri = NetworkUtils.dropQuery(uri);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        this.lock.readLock().lock();
        try {
            eTagItem = this.index.get(uri);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (eTagItem == null) {
            return;
        }
        if (eTagItem.eTag != null) {
            requestBuilder.header("if-none-match", eTagItem.eTag);
        }
    }

    public Path cacheRemoteFile(HttpResponse<?> response, Path downloaded) throws IOException {
        return this.cacheData(response, () -> {
            String hash = DigestUtils.digestToString(SHA1, downloaded);
            Path cached = this.cacheFile(downloaded, SHA1, hash);
            return new CacheResult(hash, cached);
        });
    }

    public Path cacheText(HttpResponse<?> response, String text) throws IOException {
        return this.cacheBytes(response, text.getBytes(StandardCharsets.UTF_8));
    }

    public Path cacheBytes(HttpResponse<?> response, byte[] bytes) throws IOException {
        return this.cacheData(response, () -> {
            String hash = DigestUtils.digestToString(SHA1, bytes);
            Path cached = this.getFile(SHA1, hash);
            Files.createDirectories(cached.getParent(), new FileAttribute[0]);
            Files.write(cached, bytes, new OpenOption[0]);
            return new CacheResult(hash, cached);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path cacheData(HttpResponse<?> response, ExceptionalSupplier<CacheResult, IOException> cacheSupplier) throws IOException {
        long expires;
        URI uri;
        String eTag;
        block10: {
            eTag = response.headers().firstValue("etag").orElse(null);
            if (StringUtils.isBlank(eTag)) {
                return null;
            }
            uri = NetworkUtils.dropQuery(response.uri());
            expires = 0L;
            try {
                String expiresHeader;
                String cacheControl = response.headers().firstValue("cache-control").orElse(null);
                if (StringUtils.isNotBlank(cacheControl)) {
                    if (cacheControl.contains("no-store")) {
                        return null;
                    }
                    Matcher matcher = MAX_AGE.matcher(cacheControl);
                    if (matcher.find()) {
                        long seconds = Long.parseLong(matcher.group("time"));
                        expires = Instant.now().plusSeconds(seconds).toEpochMilli();
                        break block10;
                    }
                }
                if (StringUtils.isNotBlank(expiresHeader = (String)response.headers().firstValue("expires").orElse(null))) {
                    expires = ZonedDateTime.parse(expiresHeader.trim(), DateTimeFormatter.RFC_1123_DATE_TIME).toInstant().toEpochMilli();
                }
            }
            catch (Throwable e) {
                Logger.LOG.warning("Failed to parse expires time", e);
            }
        }
        String lastModified = response.headers().firstValue("last-modified").orElse(null);
        CacheResult cacheResult = cacheSupplier.get();
        ETagItem eTagItem = new ETagItem(uri.toString(), eTag, cacheResult.hash, Files.getLastModifiedTime(cacheResult.cachedFile, new LinkOption[0]).toMillis(), lastModified, expires);
        this.lock.writeLock().lock();
        try {
            this.index.compute(uri, this.updateEntity(eTagItem, true));
            this.saveETagIndex();
            return cacheResult.cachedFile;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private BiFunction<URI, ETagItem, ETagItem> updateEntity(ETagItem newItem, boolean force) {
        return (key, oldItem) -> {
            if (oldItem == null) {
                return newItem;
            }
            if (force || oldItem.compareTo(newItem) < 0) {
                if (!oldItem.hash.equalsIgnoreCase(newItem.hash)) {
                    Path cached = this.getFile(SHA1, oldItem.hash);
                    try {
                        Files.deleteIfExists(cached);
                    }
                    catch (IOException e) {
                        Logger.LOG.warning("Cannot delete old file");
                    }
                }
                return newItem;
            }
            return oldItem;
        };
    }

    @SafeVarargs
    private LinkedHashMap<URI, ETagItem> joinETagIndexes(Collection<ETagItem> ... indexes) {
        LinkedHashMap<URI, ETagItem> eTags = new LinkedHashMap<URI, ETagItem>();
        for (Collection<ETagItem> eTagItems : indexes) {
            if (eTagItems == null) continue;
            for (ETagItem eTag : eTagItems) {
                eTags.compute(NetworkUtils.toURI(eTag.url), this.updateEntity(eTag, false));
            }
        }
        return eTags;
    }

    public void saveETagIndex() throws IOException {
        try (FileChannel channel = FileChannel.open(this.indexFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
             FileLock lock = channel.lock();){
            FileTime lastModified = Lang.ignoringException(() -> Files.getLastModifiedTime(this.indexFile, new LinkOption[0]));
            if (this.indexFileLastModified == null || lastModified == null || this.indexFileLastModified.compareTo(lastModified) < 0) {
                try {
                    ETagIndex indexOnDisk = JsonUtils.GSON.fromJson((Reader)new BufferedReader(Channels.newReader((ReadableByteChannel)channel, StandardCharsets.UTF_8)), ETagIndex.class);
                    if (indexOnDisk != null) {
                        this.index = this.joinETagIndexes(this.index.values(), indexOnDisk.eTag);
                        this.indexFileLastModified = lastModified;
                    }
                }
                catch (JsonSyntaxException indexOnDisk) {
                    // empty catch block
                }
            }
            channel.truncate(0L);
            BufferedWriter writer = new BufferedWriter(Channels.newWriter((WritableByteChannel)channel, StandardCharsets.UTF_8));
            JsonUtils.GSON.toJson((Object)new ETagIndex(this.index.values()), (Appendable)writer);
            writer.flush();
            channel.force(true);
            this.indexFileLastModified = Lang.ignoringException(() -> Files.getLastModifiedTime(this.indexFile, new LinkOption[0]));
        }
    }

    public static CacheRepository getInstance() {
        return instance;
    }

    public static void setInstance(CacheRepository instance) {
        CacheRepository.instance = instance;
    }

    private static final class ETagIndex {
        private final Collection<ETagItem> eTag;

        public ETagIndex() {
            this.eTag = new HashSet<ETagItem>();
        }

        public ETagIndex(Collection<ETagItem> eTags) {
            this.eTag = new HashSet<ETagItem>(eTags);
        }
    }

    private static final class ETagItem {
        private final String url;
        private final String eTag;
        private final String hash;
        @SerializedName(value="local")
        private final long localLastModified;
        @SerializedName(value="remote")
        private final String remoteLastModified;
        private final long expires;

        public ETagItem() {
            this(null, null, null, 0L, null, 0L);
        }

        public ETagItem(String url, String eTag, String hash, long localLastModified, String remoteLastModified, long expires) {
            this.url = url;
            this.eTag = eTag;
            this.hash = hash;
            this.localLastModified = localLastModified;
            this.remoteLastModified = remoteLastModified;
            this.expires = expires;
        }

        public long getExpires() {
            return this.expires;
        }

        public int compareTo(ETagItem other) {
            if (!this.url.equals(other.url) && !NetworkUtils.toURI(this.url).equals(NetworkUtils.toURI(other.url))) {
                throw new IllegalArgumentException();
            }
            ZonedDateTime thisTime = Lang.ignoringException(() -> ZonedDateTime.parse(this.remoteLastModified, DateTimeFormatter.RFC_1123_DATE_TIME), null);
            ZonedDateTime otherTime = Lang.ignoringException(() -> ZonedDateTime.parse(other.remoteLastModified, DateTimeFormatter.RFC_1123_DATE_TIME), null);
            if (thisTime == null && otherTime == null) {
                return 0;
            }
            if (thisTime == null) {
                return 1;
            }
            if (otherTime == null) {
                return -1;
            }
            return thisTime.compareTo(otherTime);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ETagItem)) return false;
            ETagItem that = (ETagItem)o;
            if (this.localLastModified != that.localLastModified) return false;
            if (!Objects.equals(this.url, that.url)) return false;
            if (!Objects.equals(this.eTag, that.eTag)) return false;
            if (!Objects.equals(this.hash, that.hash)) return false;
            if (!Objects.equals(this.remoteLastModified, that.remoteLastModified)) return false;
            if (this.expires != that.expires) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.url, this.eTag, this.hash, this.localLastModified, this.remoteLastModified, this.expires);
        }

        public String toString() {
            return "ETagItem[url='" + this.url + "', eTag='" + this.eTag + "', hash='" + this.hash + "', localLastModified=" + this.localLastModified + ", remoteLastModified='" + this.remoteLastModified + "', expires=" + this.expires + "]";
        }
    }

    public static class CacheExpiredException
    extends IOException {
        private final long expires;

        public CacheExpiredException(long expires) {
            this.expires = expires;
        }

        public CacheExpiredException(String message, long expires) {
            super(message);
            this.expires = expires;
        }

        public long getExpires() {
            return this.expires;
        }
    }

    private static final class CacheResult {
        public String hash;
        public Path cachedFile;

        public CacheResult(String hash, Path cachedFile) {
            this.hash = hash;
            this.cachedFile = cachedFile;
        }
    }
}

