/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jackhuang.hmcl.mod.Datapack;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

final class DatapackListPageSkin
extends SkinBase<DatapackListPage> {
    private final TransitionPane toolbarPane;
    private final HBox searchBar;
    private final HBox normalToolbar;
    private final HBox selectingToolbar;
    InvalidationListener updateBarByStateWeakListener;
    private final JFXListView<DatapackInfoObject> listView;
    private final FilteredList<DatapackInfoObject> filteredList;
    private final BooleanProperty isSearching = new SimpleBooleanProperty(false);
    private final BooleanProperty isSelecting = new SimpleBooleanProperty(false);
    private final JFXTextField searchField;
    private static final AtomicInteger lastShiftClickIndex = new AtomicInteger(-1);
    final Consumer<Integer> toggleSelect;

    DatapackListPageSkin(DatapackListPage skinnable) {
        super((Control)skinnable);
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0));
        pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        this.listView = new JFXListView();
        this.filteredList = new FilteredList(skinnable.getItems());
        this.toolbarPane = new TransitionPane();
        this.searchBar = new HBox();
        this.normalToolbar = new HBox();
        this.selectingToolbar = new HBox();
        Object[] objectArray = new Node[4];
        objectArray[0] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh);
        objectArray[1] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("datapack.add"), SVG.ADD, skinnable::add);
        objectArray[2] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.reveal_dir"), SVG.FOLDER_OPEN, skinnable::openDataPackFolder);
        objectArray[3] = ToolbarListPageSkin.createToolbarButton2(I18n.i18n("search"), SVG.SEARCH, () -> this.isSearching.set(true));
        this.normalToolbar.getChildren().addAll(objectArray);
        this.selectingToolbar.getChildren().addAll((Object[])new Node[]{ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.remove"), SVG.DELETE, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<DatapackInfoObject>)this.listView.getSelectionModel().getSelectedItems()), null)), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.enable"), SVG.CHECK, () -> skinnable.enableSelected((ObservableList<DatapackInfoObject>)this.listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.disable"), SVG.CLOSE, () -> skinnable.disableSelected((ObservableList<DatapackInfoObject>)this.listView.getSelectionModel().getSelectedItems())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.select_all"), SVG.SELECT_ALL, () -> this.listView.getSelectionModel().selectRange(0, this.listView.getItems().size())), ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.cancel"), SVG.CANCEL, () -> this.listView.getSelectionModel().clearSelection())});
        this.searchBar.setAlignment(Pos.CENTER);
        this.searchBar.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        this.searchField = new JFXTextField();
        this.searchField.setPromptText(I18n.i18n("search"));
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.ALWAYS);
        PauseTransition pause = new PauseTransition(Duration.millis((double)100.0));
        pause.setOnFinished(e -> this.filteredList.setPredicate(skinnable.updateSearchPredicate(this.searchField.getText())));
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> {
            pause.setRate(1.0);
            pause.playFromStart();
        });
        JFXButton closeSearchBar = ToolbarListPageSkin.createToolbarButton2(null, SVG.CLOSE, () -> {
            this.isSearching.set(false);
            this.searchField.clear();
        });
        FXUtils.onEscPressed((Node)this.searchField, () -> ((JFXButton)closeSearchBar).fire());
        this.searchBar.getChildren().addAll((Object[])new Node[]{this.searchField, closeSearchBar});
        root.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE && this.listView.getSelectionModel().getSelectedItem() != null) {
                this.listView.getSelectionModel().clearSelection();
                e.consume();
            }
        });
        FXUtils.onChangeAndOperate(this.listView.getSelectionModel().selectedItemProperty(), selectedItem -> this.isSelecting.set(selectedItem != null));
        root.getContent().add((Object)this.toolbarPane);
        this.updateBarByStateWeakListener = FXUtils.observeWeak(() -> {
            if (this.isSelecting.get()) {
                this.changeToolbar(this.selectingToolbar);
            } else if (!this.isSelecting.get() && !this.isSearching.get()) {
                this.changeToolbar(this.normalToolbar);
            } else {
                this.changeToolbar(this.searchBar);
            }
        }, new Observable[]{this.isSearching, this.isSelecting});
        SpinnerPane center = new SpinnerPane();
        ComponentList.setVgrow((Node)center, Priority.ALWAYS);
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        this.listView.setCellFactory(x -> new DatapackInfoListCell(this.listView));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.listView.setItems((ObservableList)this.filteredList);
        FXUtils.ignoreEvent(this.listView, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
        center.setContent((Node)this.listView);
        root.getContent().add((Object)center);
        this.toggleSelect = i -> {
            if (this.listView.getSelectionModel().isSelected(i.intValue())) {
                this.listView.getSelectionModel().clearSelection(i.intValue());
            } else {
                this.listView.getSelectionModel().select(i.intValue());
            }
        };
        pane.getChildren().setAll((Object[])new Node[]{root});
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    private void changeToolbar(HBox newToolbar) {
        Node oldToolbar = this.toolbarPane.getCurrentNode();
        if (newToolbar != oldToolbar) {
            this.toolbarPane.setContent((Node)newToolbar, ContainerAnimations.FADE);
            if (newToolbar == this.searchBar) {
                Platform.runLater(() -> ((JFXTextField)this.searchField).requestFocus());
            }
        }
    }

    public void handleSelect(DatapackInfoListCell cell, MouseEvent mouseEvent) {
        if (cell.isEmpty()) {
            mouseEvent.consume();
            return;
        }
        if (mouseEvent.isShiftDown()) {
            int currentIndex = cell.getIndex();
            if (lastShiftClickIndex.get() == -1) {
                lastShiftClickIndex.set(currentIndex);
                this.toggleSelect.accept(cell.getIndex());
            } else if (this.listView.getItems().size() >= lastShiftClickIndex.get() && lastShiftClickIndex.get() >= -1) {
                if (cell.isSelected()) {
                    IntStream.rangeClosed(Math.min(lastShiftClickIndex.get(), currentIndex), Math.max(lastShiftClickIndex.get(), currentIndex)).forEach(arg_0 -> ((MultipleSelectionModel)this.listView.getSelectionModel()).clearSelection(arg_0));
                } else {
                    this.listView.getSelectionModel().selectRange(lastShiftClickIndex.get(), currentIndex);
                    this.listView.getSelectionModel().select(currentIndex);
                }
                lastShiftClickIndex.set(-1);
            } else {
                lastShiftClickIndex.set(currentIndex);
                this.listView.getSelectionModel().select(currentIndex);
            }
        } else {
            this.toggleSelect.accept(cell.getIndex());
        }
        cell.requestFocus();
        mouseEvent.consume();
    }

    private final class DatapackInfoListCell
    extends MDListCell<DatapackInfoObject> {
        final JFXCheckBox checkBox;
        ImageView imageView;
        final TwoLineListItem content;
        BooleanProperty booleanProperty;

        DatapackInfoListCell(JFXListView<DatapackInfoObject> listView) {
            super(listView);
            this.checkBox = new JFXCheckBox();
            this.imageView = new ImageView();
            this.content = new TwoLineListItem();
            HBox container = new HBox(8.0);
            container.setPickOnBounds(false);
            container.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            this.content.setMouseTransparent(true);
            this.setSelectable();
            this.imageView.setFitWidth(32.0);
            this.imageView.setFitHeight(32.0);
            this.imageView.setPreserveRatio(true);
            this.imageView.setImage(FXUtils.newBuiltinImage("/assets/img/unknown_pack.png"));
            StackPane.setMargin((Node)container, (Insets)new Insets(8.0));
            container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.imageView, this.content});
            this.getContainer().getChildren().setAll((Object[])new Node[]{container});
            this.getContainer().getParent().addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent -> DatapackListPageSkin.this.handleSelect(this, (MouseEvent)mouseEvent));
        }

        @Override
        protected void updateControl(DatapackInfoObject dataItem, boolean empty) {
            if (empty) {
                return;
            }
            this.content.setTitle(dataItem.getTitle());
            this.content.setSubtitle(dataItem.getSubtitle());
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
            }
            this.booleanProperty = dataItem.activeProperty;
            this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
            dataItem.loadIcon(this.imageView, new WeakReference<ObjectProperty<DatapackInfoObject>>(this.itemProperty()));
        }
    }

    static class DatapackInfoObject
    extends RecursiveTreeObject<DatapackInfoObject> {
        private final BooleanProperty activeProperty;
        private final Datapack.Pack packInfo;
        private SoftReference<CompletableFuture<Image>> iconCache;

        DatapackInfoObject(Datapack.Pack packInfo) {
            this.packInfo = packInfo;
            this.activeProperty = packInfo.activeProperty();
        }

        String getTitle() {
            return this.packInfo.getId();
        }

        String getSubtitle() {
            return this.packInfo.getDescription().toString();
        }

        Datapack.Pack getPackInfo() {
            return this.packInfo;
        }

        Image loadIcon() {
            Image image = null;
            if (this.getPackInfo().isDirectory()) {
                Path imagePath = this.getPackInfo().getPath().resolve("pack.png");
                try {
                    image = FXUtils.loadImage(imagePath, 64, 64, true, true);
                }
                catch (Exception e) {
                    Logger.LOG.warning("fail to load image, datapack path: " + String.valueOf(this.getPackInfo().getPath()), e);
                    return FXUtils.newBuiltinImage("/assets/img/unknown_pack.png");
                }
            }
            try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.getPackInfo().getPath());){
                Path imagePath = fs.getPath("/pack.png", new String[0]);
                if (Files.exists(imagePath, new LinkOption[0])) {
                    image = FXUtils.loadImage(imagePath, 64, 64, true, true);
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("fail to load image, datapack path: " + String.valueOf(this.getPackInfo().getPath()), e);
                return FXUtils.newBuiltinImage("/assets/img/unknown_pack.png");
            }
            if (image != null && !image.isError() && image.getWidth() > 0.0 && image.getHeight() > 0.0 && Math.abs(image.getWidth() - image.getHeight()) < 1.0) {
                return image;
            }
            return FXUtils.newBuiltinImage("/assets/img/unknown_pack.png");
        }

        public void loadIcon(ImageView imageView, @Nullable WeakReference<ObjectProperty<DatapackInfoObject>> current) {
            CompletableFuture<Image> imageFuture;
            SoftReference<CompletableFuture<Image>> iconCache = this.iconCache;
            if (iconCache != null && (imageFuture = iconCache.get()) != null) {
                Image image2 = imageFuture.getNow(null);
                if (image2 != null) {
                    imageView.setImage(image2);
                    return;
                }
            } else {
                imageFuture = CompletableFuture.supplyAsync(this::loadIcon, Schedulers.io());
                this.iconCache = new SoftReference<CompletableFuture<Image>>(imageFuture);
            }
            imageView.setImage(FXUtils.newBuiltinImage("/assets/img/unknown_pack.png"));
            imageFuture.thenAcceptAsync(image -> {
                ObjectProperty infoObjectProperty;
                if (current != null && ((infoObjectProperty = (ObjectProperty)current.get()) == null || infoObjectProperty.get() != this)) {
                    return;
                }
                imageView.setImage(image);
            }, Schedulers.javafx());
        }
    }
}

