/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.validation.base.ValidatorBase;
import java.nio.charset.Charset;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ManuallyCreatedModpackException;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.WebPage;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.RequiredValidator;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.ModpackPage;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class LocalModpackPage
extends ModpackPage {
    private final BooleanProperty installAsVersion = new SimpleBooleanProperty(true);
    private Modpack manifest = null;
    private Charset charset;
    public static final SettingsMap.Key<Path> MODPACK_FILE = new SettingsMap.Key("MODPACK_FILE");
    public static final SettingsMap.Key<String> MODPACK_NAME = new SettingsMap.Key("MODPACK_NAME");
    public static final SettingsMap.Key<Modpack> MODPACK_MANIFEST = new SettingsMap.Key("MODPACK_MANIFEST");
    public static final SettingsMap.Key<Charset> MODPACK_CHARSET = new SettingsMap.Key("MODPACK_CHARSET");
    public static final SettingsMap.Key<Boolean> MODPACK_MANUALLY_CREATED = new SettingsMap.Key("MODPACK_MANUALLY_CREATED");
    public static final SettingsMap.Key<String> MODPACK_ICON_URL = new SettingsMap.Key("MODPACK_ICON_URL");

    public LocalModpackPage(WizardController controller) {
        super(controller);
        Path selectedFile;
        Profile profile = controller.getSettings().get(ModpackPage.PROFILE);
        String name = controller.getSettings().get(MODPACK_NAME);
        if (name != null) {
            this.txtModpackName.setText(name);
            this.txtModpackName.setDisable(true);
        } else {
            FXUtils.onChangeAndOperate(this.installAsVersion, installAsVersion -> {
                if (installAsVersion.booleanValue()) {
                    this.txtModpackName.getValidators().setAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !profile.getRepository().versionIdConflicts((String)str)), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
                } else {
                    this.txtModpackName.getValidators().setAll((Object[])new ValidatorBase[]{new RequiredValidator(), new Validator(I18n.i18n("install.new_game.already_exists"), str -> !ModpackHelper.isExternalGameNameConflicts(str) && Profiles.getProfiles().stream().noneMatch(p -> p.getName().equals(str))), new Validator(I18n.i18n("install.new_game.malformed"), HMCLGameRepository::isValidVersionId)});
                }
            });
        }
        this.btnDescription.setVisible(false);
        Path filePath = controller.getSettings().get(MODPACK_FILE);
        if (filePath != null) {
            selectedFile = filePath;
        } else {
            FileChooser chooser = new FileChooser();
            chooser.setTitle(I18n.i18n("modpack.choose"));
            chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
            selectedFile = FileUtils.toPath(chooser.showOpenDialog((Window)Controllers.getStage()));
            if (selectedFile == null) {
                controller.onEnd();
                return;
            }
            controller.getSettings().put(MODPACK_FILE, selectedFile);
        }
        this.showSpinner();
        Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(selectedFile)).thenApplyAsync(encoding -> {
            this.charset = encoding;
            this.manifest = ModpackHelper.readModpackManifest(selectedFile, encoding);
            return this.manifest;
        }).whenComplete(Schedulers.javafx(), (manifest, exception) -> {
            if (exception instanceof ManuallyCreatedModpackException) {
                this.hideSpinner();
                this.lblName.setText(FileUtils.getName(selectedFile));
                this.installAsVersion.set(false);
                if (name == null) {
                    this.txtModpackName.setText(FileUtils.getNameWithoutExtension(selectedFile));
                }
                Controllers.confirm(I18n.i18n("modpack.type.manual.warning"), I18n.i18n("install.modpack"), MessageDialogPane.MessageType.WARNING, () -> {}, controller::onEnd);
                controller.getSettings().put(MODPACK_MANUALLY_CREATED, true);
            } else if (exception != null) {
                Logger.LOG.warning("Failed to read modpack manifest", exception);
                Controllers.dialog(I18n.i18n("modpack.task.install.error"), I18n.i18n("message.error"), MessageDialogPane.MessageType.ERROR);
                Platform.runLater(controller::onEnd);
            } else {
                this.hideSpinner();
                controller.getSettings().put(MODPACK_MANIFEST, manifest);
                this.lblName.setText(manifest.getName());
                this.lblVersion.setText(manifest.getVersion());
                this.lblAuthor.setText(manifest.getAuthor());
                if (name == null) {
                    this.txtModpackName.setText(manifest.getName().trim());
                }
                this.btnDescription.setVisible(StringUtils.isNotBlank(manifest.getDescription()));
            }
        }).start();
    }

    @Override
    public void cleanup(SettingsMap settings) {
        settings.remove(MODPACK_FILE);
    }

    @Override
    protected void onInstall() {
        String name = this.txtModpackName.getText();
        if (!StringUtils.isASCII(name)) {
            Controllers.dialog((Region)new MessageDialogPane.Builder(I18n.i18n("install.name.invalid"), I18n.i18n("message.warning"), MessageDialogPane.MessageType.QUESTION).yesOrNo(() -> {
                this.controller.getSettings().put(MODPACK_NAME, name);
                this.controller.getSettings().put(MODPACK_CHARSET, this.charset);
                this.controller.onFinish();
            }, () -> {}).build());
        } else {
            this.controller.getSettings().put(MODPACK_NAME, name);
            this.controller.getSettings().put(MODPACK_CHARSET, this.charset);
            this.controller.onFinish();
        }
    }

    @Override
    protected void onDescribe() {
        if (this.manifest != null) {
            Controllers.navigate((Node)new WebPage(I18n.i18n("modpack.description"), this.manifest.getDescription()));
        }
    }
}

