/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import com.jfoenix.controls.JFXSnackbar;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.Motion;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorSkin;
import org.jackhuang.hmcl.ui.wizard.Navigation;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class Decorator
extends Control {
    private final ListProperty<Node> drawer = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<Node> content = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<Node> container = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<Background> contentBackground = new SimpleObjectProperty();
    private final ObjectProperty<DecoratorPage.State> state = new SimpleObjectProperty();
    private final StringProperty drawerTitle = new SimpleStringProperty();
    private final ObjectProperty<Runnable> onCloseButtonAction = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onCloseNavButtonAction = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onBackNavButtonAction = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<ActionEvent>> onRefreshNavButtonAction = new SimpleObjectProperty();
    private final BooleanProperty canRefresh = new SimpleBooleanProperty(false);
    private final BooleanProperty canBack = new SimpleBooleanProperty(false);
    private final BooleanProperty canClose = new SimpleBooleanProperty(false);
    private final BooleanProperty showCloseAsHome = new SimpleBooleanProperty(false);
    private final BooleanProperty titleTransparent = new SimpleBooleanProperty(false);
    private final Stage primaryStage;
    private Navigation.NavigationDirection navigationDirection = Navigation.NavigationDirection.START;
    private StackPane drawerWrapper;
    private final JFXSnackbar snackbar = new JFXSnackbar();
    private final ReadOnlyBooleanWrapper allowMove = new ReadOnlyBooleanWrapper();
    private final ReadOnlyBooleanWrapper dragging = new ReadOnlyBooleanWrapper();
    private boolean playRestoreMinimizeAnimation = false;

    public Decorator(Stage primaryStage) {
        this.primaryStage = primaryStage;
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        primaryStage.initStyle(StageStyle.UNDECORATED);
        if (AnimationUtils.playWindowAnimation()) {
            FXUtils.onChange(primaryStage.iconifiedProperty(), iconified -> {
                if (this.playRestoreMinimizeAnimation && !iconified.booleanValue()) {
                    this.playRestoreMinimizeAnimation = false;
                    Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Motion.EASE), new KeyValue((WritableValue)this.translateYProperty(), (Object)200, Motion.EASE), new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.4, Motion.EASE), new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.4, Motion.EASE), new KeyValue((WritableValue)this.scaleZProperty(), (Object)0.4, Motion.EASE)}), new KeyFrame(Motion.SHORT4, new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Motion.EASE), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Motion.EASE), new KeyValue((WritableValue)this.scaleXProperty(), (Object)1, Motion.EASE), new KeyValue((WritableValue)this.scaleYProperty(), (Object)1, Motion.EASE), new KeyValue((WritableValue)this.scaleZProperty(), (Object)1, Motion.EASE)})});
                    timeline.play();
                }
            });
        }
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }

    public StackPane getDrawerWrapper() {
        return this.drawerWrapper;
    }

    public void setDrawerWrapper(StackPane drawerWrapper) {
        this.drawerWrapper = drawerWrapper;
    }

    public ObservableList<Node> getDrawer() {
        return (ObservableList)this.drawer.get();
    }

    public ListProperty<Node> drawerProperty() {
        return this.drawer;
    }

    public void setDrawer(ObservableList<Node> drawer) {
        this.drawer.set(drawer);
    }

    public ObservableList<Node> getContent() {
        return (ObservableList)this.content.get();
    }

    public ListProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(ObservableList<Node> content) {
        this.content.set(content);
    }

    public DecoratorPage.State getState() {
        return (DecoratorPage.State)this.state.get();
    }

    public ObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }

    public void setState(DecoratorPage.State state) {
        this.state.set((Object)state);
    }

    public String getDrawerTitle() {
        return (String)this.drawerTitle.get();
    }

    public StringProperty drawerTitleProperty() {
        return this.drawerTitle;
    }

    public void setDrawerTitle(String drawerTitle) {
        this.drawerTitle.set((Object)drawerTitle);
    }

    public Runnable getOnCloseButtonAction() {
        return (Runnable)this.onCloseButtonAction.get();
    }

    public ObjectProperty<Runnable> onCloseButtonActionProperty() {
        return this.onCloseButtonAction;
    }

    public void setOnCloseButtonAction(Runnable onCloseButtonAction) {
        this.onCloseButtonAction.set((Object)onCloseButtonAction);
    }

    public ObservableList<Node> getContainer() {
        return (ObservableList)this.container.get();
    }

    public ListProperty<Node> containerProperty() {
        return this.container;
    }

    public void setContainer(ObservableList<Node> container) {
        this.container.set(container);
    }

    public Background getContentBackground() {
        return (Background)this.contentBackground.get();
    }

    public ObjectProperty<Background> contentBackgroundProperty() {
        return this.contentBackground;
    }

    public void setContentBackground(Background contentBackground) {
        this.contentBackground.set((Object)contentBackground);
    }

    public BooleanProperty canRefreshProperty() {
        return this.canRefresh;
    }

    public BooleanProperty canBackProperty() {
        return this.canBack;
    }

    public BooleanProperty canCloseProperty() {
        return this.canClose;
    }

    public BooleanProperty showCloseAsHomeProperty() {
        return this.showCloseAsHome;
    }

    public boolean isAllowMove() {
        return this.allowMove.get();
    }

    public ReadOnlyBooleanProperty allowMoveProperty() {
        return this.allowMove.getReadOnlyProperty();
    }

    void setAllowMove(boolean allowMove) {
        this.allowMove.set(allowMove);
    }

    public boolean isDragging() {
        return this.dragging.get();
    }

    public ReadOnlyBooleanProperty draggingProperty() {
        return this.dragging.getReadOnlyProperty();
    }

    void setDragging(boolean dragging) {
        this.dragging.set(dragging);
    }

    public boolean isTitleTransparent() {
        return this.titleTransparent.get();
    }

    public BooleanProperty titleTransparentProperty() {
        return this.titleTransparent;
    }

    public void setTitleTransparent(boolean titleTransparent) {
        this.titleTransparent.set(titleTransparent);
    }

    public ObjectProperty<EventHandler<ActionEvent>> onBackNavButtonActionProperty() {
        return this.onBackNavButtonAction;
    }

    public ObjectProperty<EventHandler<ActionEvent>> onCloseNavButtonActionProperty() {
        return this.onCloseNavButtonAction;
    }

    public ObjectProperty<EventHandler<ActionEvent>> onRefreshNavButtonActionProperty() {
        return this.onRefreshNavButtonAction;
    }

    public JFXSnackbar getSnackbar() {
        return this.snackbar;
    }

    protected Skin<?> createDefaultSkin() {
        return new DecoratorSkin(this);
    }

    public void minimize() {
        if (AnimationUtils.playWindowAnimation() && OperatingSystem.CURRENT_OS != OperatingSystem.MACOS) {
            this.playRestoreMinimizeAnimation = true;
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)1, Motion.EASE), new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Motion.EASE), new KeyValue((WritableValue)this.scaleXProperty(), (Object)1, Motion.EASE), new KeyValue((WritableValue)this.scaleYProperty(), (Object)1, Motion.EASE), new KeyValue((WritableValue)this.scaleZProperty(), (Object)1, Motion.EASE)}), new KeyFrame(Motion.SHORT4, new KeyValue[]{new KeyValue((WritableValue)this.opacityProperty(), (Object)0, Motion.EASE), new KeyValue((WritableValue)this.translateYProperty(), (Object)200, Motion.EASE), new KeyValue((WritableValue)this.scaleXProperty(), (Object)0.4, Motion.EASE), new KeyValue((WritableValue)this.scaleYProperty(), (Object)0.4, Motion.EASE), new KeyValue((WritableValue)this.scaleZProperty(), (Object)0.4, Motion.EASE)})});
            timeline.setOnFinished(event -> this.primaryStage.setIconified(true));
            timeline.play();
        } else {
            this.primaryStage.setIconified(true);
        }
    }

    public void close() {
        ((Runnable)this.onCloseButtonAction.get()).run();
    }

    public void capableDraggingWindow(Node node) {
        node.addEventHandler(MouseEvent.MOUSE_MOVED, e -> this.allowMove.set(true));
        node.addEventHandler(MouseEvent.MOUSE_EXITED, e -> {
            if (!this.isDragging()) {
                this.allowMove.set(false);
            }
        });
    }

    public void forbidDraggingWindow(Node node) {
        node.addEventHandler(MouseEvent.MOUSE_MOVED, e -> {
            this.allowMove.set(false);
            e.consume();
        });
    }

    public Navigation.NavigationDirection getNavigationDirection() {
        return this.navigationDirection;
    }

    public void setNavigationDirection(Navigation.NavigationDirection navigationDirection) {
        this.navigationDirection = navigationDirection;
    }
}

