/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXListView;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;

public abstract class ToolbarListPageSkin<E, P extends ListPageBase<E>>
extends SkinBase<P> {
    protected final JFXListView<E> listView;

    public ToolbarListPageSkin(P skinnable) {
        super(skinnable);
        SpinnerPane spinnerPane = new SpinnerPane();
        spinnerPane.loadingProperty().bind((ObservableValue)((ListPageBase)skinnable).loadingProperty());
        spinnerPane.failedReasonProperty().bind((ObservableValue)((ListPageBase)skinnable).failedReasonProperty());
        spinnerPane.onFailedActionProperty().bind(((ListPageBase)skinnable).onFailedActionProperty());
        spinnerPane.getStyleClass().add((Object)"large-spinner-pane");
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        StackPane.setMargin((Node)root, (Insets)new Insets(10.0));
        List<Node> toolbarButtons = this.initializeToolbar(skinnable);
        if (!toolbarButtons.isEmpty()) {
            HBox toolbar = new HBox();
            toolbar.setAlignment(Pos.CENTER_LEFT);
            toolbar.setPickOnBounds(false);
            toolbar.getChildren().setAll(toolbarButtons);
            root.getContent().add((Object)toolbar);
        }
        this.listView = new JFXListView();
        this.listView.setPadding(Insets.EMPTY);
        this.listView.setCellFactory(listView -> this.createListCell((JFXListView)((Object)listView)));
        ComponentList.setVgrow(this.listView, Priority.ALWAYS);
        Bindings.bindContent((List)this.listView.getItems(), ((ListPageBase)skinnable).itemsProperty());
        root.getContent().add(this.listView);
        spinnerPane.setContent((Node)root);
        this.getChildren().setAll((Object[])new Node[]{spinnerPane});
    }

    public static Node wrap(Node node) {
        StackPane stackPane = new StackPane();
        stackPane.setPadding(new Insets(0.0, 5.0, 0.0, 2.0));
        stackPane.getChildren().setAll((Object[])new Node[]{node});
        return stackPane;
    }

    public static JFXButton createToolbarButton2(String text, SVG svg, Runnable onClick) {
        JFXButton ret = new JFXButton();
        ret.getStyleClass().add((Object)"jfx-tool-bar-button");
        ret.setGraphic(ToolbarListPageSkin.wrap(svg.createIcon()));
        ret.setText(text);
        ret.setOnAction(e -> onClick.run());
        return ret;
    }

    public static JFXButton createDecoratorButton(String tooltip, SVG svg, Runnable onClick) {
        JFXButton ret = new JFXButton();
        ret.getStyleClass().add((Object)"jfx-decorator-button");
        ret.setGraphic(ToolbarListPageSkin.wrap(svg.createIcon()));
        FXUtils.installFastTooltip((Node)ret, tooltip);
        ret.setOnAction(e -> onClick.run());
        return ret;
    }

    protected abstract List<Node> initializeToolbar(P var1);

    protected ListCell<E> createListCell(JFXListView<E> listView) {
        return new ListCell<E>(){

            protected void updateItem(E item, boolean empty) {
                super.updateItem(item, empty);
                if (!empty && item instanceof Node) {
                    Node node = (Node)item;
                    this.setGraphic(node);
                    this.setText(null);
                } else {
                    this.setGraphic(null);
                    this.setText(null);
                }
            }
        };
    }
}

