/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXDialog;
import com.jfoenix.controls.events.JFXDialogEvent;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.construct.DialogAware;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.JFXDialogPane;
import org.jackhuang.hmcl.ui.decorator.Decorator;
import org.jetbrains.annotations.Nullable;

public final class DialogUtils {
    public static final String PROPERTY_DIALOG_INSTANCE = DialogUtils.class.getName() + ".dialog.instance";
    public static final String PROPERTY_DIALOG_PANE_INSTANCE = DialogUtils.class.getName() + ".dialog.pane.instance";
    public static final String PROPERTY_DIALOG_CLOSE_HANDLER = DialogUtils.class.getName() + ".dialog.closeListener";
    public static final String PROPERTY_PARENT_PANE_REF = DialogUtils.class.getName() + ".dialog.parentPaneRef";
    public static final String PROPERTY_PARENT_DIALOG_REF = DialogUtils.class.getName() + ".dialog.parentDialogRef";

    private DialogUtils() {
    }

    public static void show(Decorator decorator, Node content) {
        if (decorator.getDrawerWrapper() == null) {
            Platform.runLater(() -> DialogUtils.show(decorator, content));
            return;
        }
        DialogUtils.show(decorator.getDrawerWrapper(), content, dialog -> {
            JFXDialogPane pane = (JFXDialogPane)dialog.getContent();
            decorator.capableDraggingWindow((Node)dialog);
            decorator.forbidDraggingWindow((Node)pane);
            dialog.setDialogContainer(decorator.getDrawerWrapper());
        });
    }

    public static void show(StackPane container, Node content) {
        DialogUtils.show(container, content, null);
    }

    public static void show(StackPane container, Node content, @Nullable Consumer<JFXDialog> onDialogCreated) {
        FXUtils.checkFxUserThread();
        JFXDialog dialog = (JFXDialog)((Object)container.getProperties().get((Object)PROPERTY_DIALOG_INSTANCE));
        JFXDialogPane dialogPane = (JFXDialogPane)((Object)container.getProperties().get((Object)PROPERTY_DIALOG_PANE_INSTANCE));
        if (dialog == null) {
            dialog = new JFXDialog(AnimationUtils.isAnimationEnabled() ? JFXDialog.DialogTransition.CENTER : JFXDialog.DialogTransition.NONE);
            dialogPane = new JFXDialogPane();
            dialog.setContent((Region)dialogPane);
            dialog.setDialogContainer(container);
            dialog.setOverlayClose(false);
            container.getProperties().put((Object)PROPERTY_DIALOG_INSTANCE, (Object)dialog);
            container.getProperties().put((Object)PROPERTY_DIALOG_PANE_INSTANCE, (Object)dialogPane);
            if (onDialogCreated != null) {
                onDialogCreated.accept(dialog);
            }
            dialog.show();
        }
        content.getProperties().put((Object)PROPERTY_PARENT_PANE_REF, (Object)dialogPane);
        content.getProperties().put((Object)PROPERTY_PARENT_DIALOG_REF, (Object)dialog);
        dialogPane.push(content);
        EventHandler handler = event -> DialogUtils.close(content);
        content.getProperties().put((Object)PROPERTY_DIALOG_CLOSE_HANDLER, (Object)handler);
        content.addEventHandler(DialogCloseEvent.CLOSE, handler);
        DialogUtils.handleDialogShown(dialog, content);
    }

    private static void handleDialogShown(final JFXDialog dialog, final Node node) {
        if (dialog.isVisible()) {
            dialog.requestFocus();
            if (node instanceof DialogAware) {
                DialogAware dialogAware = (DialogAware)node;
                dialogAware.onDialogShown();
            }
        } else {
            dialog.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        dialog.requestFocus();
                        if (node instanceof DialogAware) {
                            DialogAware dialogAware = (DialogAware)node;
                            dialogAware.onDialogShown();
                        }
                        observable.removeListener((ChangeListener)this);
                    }
                }
            });
        }
    }

    public static void close(Node content) {
        FXUtils.checkFxUserThread();
        Optional.ofNullable(content.getProperties().get((Object)PROPERTY_DIALOG_CLOSE_HANDLER)).ifPresent(handler -> content.removeEventHandler(DialogCloseEvent.CLOSE, (EventHandler)handler));
        JFXDialogPane pane = (JFXDialogPane)((Object)content.getProperties().get((Object)PROPERTY_PARENT_PANE_REF));
        JFXDialog dialog = (JFXDialog)((Object)content.getProperties().get((Object)PROPERTY_PARENT_DIALOG_REF));
        if (dialog != null && pane != null) {
            if (pane.size() == 1 && pane.peek().orElse(null) == content) {
                dialog.setOnDialogClosed((EventHandler<? super JFXDialogEvent>)((EventHandler)e -> pane.pop(content)));
                dialog.close();
                StackPane container = dialog.getDialogContainer();
                if (container != null) {
                    container.getProperties().remove((Object)PROPERTY_DIALOG_INSTANCE);
                    container.getProperties().remove((Object)PROPERTY_DIALOG_PANE_INSTANCE);
                    container.getProperties().remove((Object)PROPERTY_PARENT_DIALOG_REF);
                    container.getProperties().remove((Object)PROPERTY_PARENT_PANE_REF);
                }
            } else {
                pane.pop(content);
            }
            if (content instanceof DialogAware) {
                DialogAware dialogAware = (DialogAware)content;
                dialogAware.onDialogClosed();
            }
        }
    }
}

