/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaMetadata;
import org.jackhuang.hmcl.terracotta.TerracottaState;
import org.jackhuang.hmcl.terracotta.provider.AbstractTerracottaProvider;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.InvocationDispatcher;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.SystemUtils;

public final class TerracottaManager {
    private static final AtomicReference<TerracottaState> STATE_V = new AtomicReference<TerracottaState.Bootstrap>(TerracottaState.Bootstrap.INSTANCE);
    private static final ReadOnlyObjectWrapper<TerracottaState> STATE = new ReadOnlyObjectWrapper((Object)STATE_V.getPlain());
    private static final InvocationDispatcher<TerracottaState> STATE_D = InvocationDispatcher.runOn(Platform::runLater, arg_0 -> STATE.set(arg_0));
    private static final Thread DAEMON;
    private static volatile boolean daemonRunning;

    private TerracottaManager() {
    }

    public static ReadOnlyObjectProperty<TerracottaState> stateProperty() {
        return STATE.getReadOnlyProperty();
    }

    private static void runBackground() {
        long ACTIVE = TimeUnit.MILLISECONDS.toNanos(500L);
        long BACKGROUND = TimeUnit.SECONDS.toMillis(15L);
        while (true) {
            TerracottaState next;
            int n;
            TerracottaState terracottaState;
            if (daemonRunning) {
                LockSupport.parkNanos(ACTIVE);
            } else {
                long deadline = System.currentTimeMillis() + BACKGROUND;
                do {
                    LockSupport.parkUntil(deadline);
                } while (!daemonRunning && System.currentTimeMillis() < deadline - 100L);
            }
            if (!((terracottaState = STATE_V.get()) instanceof TerracottaState.PortSpecific)) continue;
            TerracottaState.PortSpecific state = (TerracottaState.PortSpecific)terracottaState;
            int port = state.port;
            if (state instanceof TerracottaState.Ready) {
                TerracottaState.Ready ready = (TerracottaState.Ready)state;
                n = ready.index;
            } else {
                n = Integer.MIN_VALUE;
            }
            int index = n;
            try {
                TerracottaState.Ready object = HttpRequest.GET(String.format("http://127.0.0.1:%d/state", port)).retry(5).getJson(TerracottaState.Ready.class);
                if (object.index <= index) continue;
                object.port = port;
                next = object;
            }
            catch (Exception e) {
                Logger.LOG.warning("Cannot fetch state from Terracotta.", e);
                next = new TerracottaState.Fatal(TerracottaState.Fatal.Type.TERRACOTTA);
            }
            TerracottaManager.compareAndSet(state, next);
        }
    }

    public static void switchDaemon(boolean active) {
        FXUtils.checkFxUserThread();
        boolean dr = daemonRunning;
        if (dr != active) {
            daemonRunning = active;
            if (active) {
                LockSupport.unpark(DAEMON);
            }
        }
    }

    private static AbstractTerracottaProvider getProvider() {
        AbstractTerracottaProvider provider = TerracottaMetadata.PROVIDER;
        if (provider == null) {
            throw new AssertionError((Object)"Terracotta Provider must NOT be null.");
        }
        return provider;
    }

    public static boolean isInvalidBundle(Path file) {
        return !FileUtils.getName(file).equalsIgnoreCase(TerracottaMetadata.PACKAGE_NAME);
    }

    public static TerracottaState.Preparing download() {
        FXUtils.checkFxUserThread();
        TerracottaState state = STATE_V.get();
        if (!(state instanceof TerracottaState.Uninitialized || state instanceof TerracottaState.Fatal && ((TerracottaState.Fatal)state).isRecoverable())) {
            return null;
        }
        TerracottaState.Preparing preparing = new TerracottaState.Preparing(new ReadOnlyDoubleWrapper(-1.0), true);
        Task.composeAsync(() -> TerracottaManager.getProvider().download(preparing)).thenComposeAsync(pkg -> {
            if (!preparing.requestInstallFence()) {
                return null;
            }
            return TerracottaManager.getProvider().install((Path)pkg).thenRunAsync(() -> {
                TerracottaState.Launching launching = new TerracottaState.Launching();
                if (TerracottaManager.compareAndSet(preparing, launching)) {
                    TerracottaManager.launch(launching, true);
                }
            });
        }).whenComplete(exception -> {
            if (!(exception instanceof CancellationException)) {
                if (exception instanceof DownloadException) {
                    TerracottaManager.compareAndSet(preparing, new TerracottaState.Fatal(TerracottaState.Fatal.Type.NETWORK));
                } else {
                    TerracottaManager.compareAndSet(preparing, new TerracottaState.Fatal(TerracottaState.Fatal.Type.INSTALL));
                }
            }
        }).start();
        return TerracottaManager.compareAndSet(state, preparing) ? preparing : null;
    }

    public static TerracottaState.Preparing install(Path bundle) {
        TerracottaState.Preparing preparing;
        TerracottaState.Preparing previousPreparing;
        FXUtils.checkFxUserThread();
        if (TerracottaManager.isInvalidBundle(bundle)) {
            return null;
        }
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.Preparing && (previousPreparing = (TerracottaState.Preparing)state).requestInstallFence()) {
            preparing = previousPreparing;
        } else if (state instanceof TerracottaState.Uninitialized || state instanceof TerracottaState.Fatal && ((TerracottaState.Fatal)state).isRecoverable()) {
            preparing = new TerracottaState.Preparing(new ReadOnlyDoubleWrapper(-1.0), false);
        } else {
            return null;
        }
        Task.composeAsync(() -> TerracottaManager.getProvider().install(bundle)).thenRunAsync(() -> {
            TerracottaState.Launching launching = new TerracottaState.Launching();
            if (TerracottaManager.compareAndSet(preparing, launching)) {
                TerracottaManager.launch(launching, true);
            }
        }).whenComplete(exception -> TerracottaManager.compareAndSet(preparing, new TerracottaState.Fatal(TerracottaState.Fatal.Type.INSTALL))).start();
        return state != preparing && TerracottaManager.compareAndSet(state, preparing) ? preparing : null;
    }

    public static TerracottaState recover() {
        FXUtils.checkFxUserThread();
        TerracottaState state = STATE_V.get();
        if (!(state instanceof TerracottaState.Fatal) || !((TerracottaState.Fatal)state).isRecoverable()) {
            return null;
        }
        try {
            return switch (TerracottaManager.getProvider().status()) {
                default -> throw new IncompatibleClassChangeError();
                case AbstractTerracottaProvider.Status.NOT_EXIST, AbstractTerracottaProvider.Status.LEGACY_VERSION -> TerracottaManager.download();
                case AbstractTerracottaProvider.Status.READY -> {
                    TerracottaState.Launching launching = TerracottaManager.setState(new TerracottaState.Launching());
                    TerracottaManager.launch(launching, false);
                    yield launching;
                }
            };
        }
        catch (IOException | RuntimeException e) {
            Logger.LOG.warning("Cannot determine Terracotta state.", e);
            return TerracottaManager.setState(new TerracottaState.Fatal(TerracottaState.Fatal.Type.UNKNOWN));
        }
    }

    private static void launch(TerracottaState.Launching state, boolean removeLegacy) {
        Task.supplyAsync(() -> {
            Path path = Files.createTempDirectory(String.format("hmcl-terracotta-%d", ThreadLocalRandom.current().nextLong()), new FileAttribute[0]).resolve("http").toAbsolutePath();
            ManagedProcess process = new ManagedProcess(new ProcessBuilder(TerracottaManager.getProvider().ofCommandLine(path)));
            process.pumpInputStream(SystemUtils::onLogLine);
            process.pumpErrorStream(SystemUtils::onLogLine);
            long exitTime = -1L;
            while (true) {
                if (Files.exists(path, new LinkOption[0])) {
                    JsonObject object = JsonUtils.fromNonNullJson(Files.readString(path), JsonObject.class);
                    return object.get("port").getAsInt();
                }
                if (process.isRunning()) continue;
                if (exitTime == -1L) {
                    exitTime = System.currentTimeMillis();
                    continue;
                }
                if (System.currentTimeMillis() - exitTime >= 10000L) break;
            }
            throw new IllegalStateException(String.format("Process has exited for 10s, code = %s", process.getExitCode()));
        }).whenComplete(Schedulers.javafx(), (port, exception) -> {
            TerracottaState next;
            if (exception == null) {
                next = new TerracottaState.Unknown((int)port);
                if (removeLegacy) {
                    TerracottaMetadata.removeLegacyVersionFiles();
                }
            } else {
                next = new TerracottaState.Fatal(TerracottaState.Fatal.Type.TERRACOTTA);
            }
            TerracottaManager.compareAndSet(state, next);
        }).start();
    }

    public static Task<String> exportLogs() {
        TerracottaState terracottaState = STATE_V.get();
        if (terracottaState instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)terracottaState;
            return new GetTask(URI.create(String.format("http://127.0.0.1:%d/log?fetch=true", portSpecific.port))).setSignificance(Task.TaskSignificance.MINOR);
        }
        return Task.completed(null);
    }

    public static TerracottaState.Waiting setWaiting() {
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
            new GetTask(URI.create(String.format("http://127.0.0.1:%d/state/ide", portSpecific.port))).setSignificance(Task.TaskSignificance.MINOR).start();
            return new TerracottaState.Waiting(-1, -1, null);
        }
        return null;
    }

    private static String getPlayerName() {
        Account account = Accounts.getSelectedAccount();
        return account != null ? account.getCharacter() : I18n.i18n("terracotta.player_anonymous");
    }

    public static TerracottaState.HostScanning setScanning() {
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
            String uri = NetworkUtils.withQuery(String.format("http://127.0.0.1:%d/state/scanning", portSpecific.port), Map.of("player", TerracottaManager.getPlayerName()));
            new GetTask(uri).setSignificance(Task.TaskSignificance.MINOR).start();
            return new TerracottaState.HostScanning(-1, -1, null);
        }
        return null;
    }

    public static Task<TerracottaState.GuestConnecting> setGuesting(String room) {
        TerracottaState state = STATE_V.get();
        if (state instanceof TerracottaState.PortSpecific) {
            TerracottaState.PortSpecific portSpecific = (TerracottaState.PortSpecific)state;
            String uri = NetworkUtils.withQuery(String.format("http://127.0.0.1:%d/state/guesting", portSpecific.port), Map.of("room", room, "player", TerracottaManager.getPlayerName()));
            return new GetTask(uri).setSignificance(Task.TaskSignificance.MINOR).thenSupplyAsync(() -> new TerracottaState.GuestConnecting(-1, -1, null)).setSignificance(Task.TaskSignificance.MINOR);
        }
        return null;
    }

    private static <T extends TerracottaState> T setState(T value) {
        if (value == null) {
            throw new AssertionError();
        }
        STATE_V.set(value);
        STATE_D.accept(value);
        return value;
    }

    private static boolean compareAndSet(TerracottaState previous, TerracottaState next) {
        if (next == null) {
            throw new AssertionError();
        }
        if (STATE_V.compareAndSet(previous, next)) {
            STATE_D.accept(next);
            return true;
        }
        return false;
    }

    static {
        Schedulers.io().execute(() -> {
            try {
                if (TerracottaMetadata.PROVIDER == null) {
                    throw new IOException("Unsupported platform: " + String.valueOf(org.jackhuang.hmcl.util.platform.Platform.CURRENT_PLATFORM));
                }
                switch (TerracottaMetadata.PROVIDER.status()) {
                    case NOT_EXIST: {
                        TerracottaManager.setState(new TerracottaState.Uninitialized(false));
                        break;
                    }
                    case LEGACY_VERSION: {
                        TerracottaManager.setState(new TerracottaState.Uninitialized(true));
                        break;
                    }
                    case READY: {
                        TerracottaManager.launch(TerracottaManager.setState(new TerracottaState.Launching()), false);
                    }
                }
            }
            catch (Exception e) {
                Logger.LOG.warning("Cannot initialize Terracotta.", e);
                TerracottaManager.compareAndSet(TerracottaState.Bootstrap.INSTANCE, new TerracottaState.Fatal(TerracottaState.Fatal.Type.UNKNOWN));
            }
        });
        DAEMON = Lang.thread(TerracottaManager::runBackground, "Terracotta Background Daemon", true);
        daemonRunning = false;
    }
}

