/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.mod.curse.CurseAddon;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.MurmurHash2;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.JarUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.Nullable;

public final class CurseForgeRemoteModRepository
implements RemoteModRepository {
    private static final String PREFIX = "https://api.curseforge.com";
    private static final String apiKey = System.getProperty("hmcl.curseforge.apikey", JarUtils.getAttribute("hmcl.curseforge.apikey", ""));
    private static final Semaphore SEMAPHORE = new Semaphore(16);
    private static final int WORD_PERFECT_MATCH_WEIGHT = 5;
    private final RemoteModRepository.Type type;
    private final int section;
    public static final int SECTION_BUKKIT_PLUGIN = 5;
    public static final int SECTION_MOD = 6;
    public static final int SECTION_RESOURCE_PACK = 12;
    public static final int SECTION_WORLD = 17;
    public static final int SECTION_MODPACK = 4471;
    public static final int SECTION_CUSTOMIZATION = 4546;
    public static final int SECTION_ADDONS = 4559;
    public static final int SECTION_UNKNOWN1 = 4944;
    public static final int SECTION_UNKNOWN2 = 4979;
    public static final int SECTION_UNKNOWN3 = 4984;
    public static final CurseForgeRemoteModRepository MODS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.MOD, 6);
    public static final CurseForgeRemoteModRepository MODPACKS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.MODPACK, 4471);
    public static final CurseForgeRemoteModRepository RESOURCE_PACKS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.RESOURCE_PACK, 12);
    public static final CurseForgeRemoteModRepository WORLDS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.WORLD, 17);
    public static final CurseForgeRemoteModRepository CUSTOMIZATIONS = new CurseForgeRemoteModRepository(RemoteModRepository.Type.CUSTOMIZATION, 4546);

    private static <R extends HttpRequest> R withApiKey(R request) {
        if (request.getUrl().startsWith(PREFIX) && !apiKey.isEmpty()) {
            request.header("X-API-KEY", apiKey);
        }
        return request;
    }

    public static boolean isAvailable() {
        return !apiKey.isEmpty();
    }

    public CurseForgeRemoteModRepository(RemoteModRepository.Type type, int section) {
        this.type = type;
        this.section = section;
    }

    @Override
    public RemoteModRepository.Type getType() {
        return this.type;
    }

    private int toModsSearchSortField(RemoteModRepository.SortType sort) {
        switch (sort) {
            case DATE_CREATED: {
                return 1;
            }
            case POPULARITY: {
                return 2;
            }
            case LAST_UPDATED: {
                return 3;
            }
            case NAME: {
                return 4;
            }
            case AUTHOR: {
                return 5;
            }
            case TOTAL_DOWNLOADS: {
                return 6;
            }
        }
        return 8;
    }

    private String toSortOrder(RemoteModRepository.SortOrder sortOrder) {
        switch (sortOrder) {
            case ASC: {
                return "asc";
            }
            case DESC: {
                return "desc";
            }
        }
        return "asc";
    }

    private int calculateTotalPages(Response<List<CurseAddon>> response, int pageSize) {
        return (int)Math.ceil((double)Math.min(response.pagination.totalCount, 10000) / (double)pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteModRepository.SearchResult search(DownloadProvider downloadProvider, String gameVersion, @Nullable RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sortType, RemoteModRepository.SortOrder sortOrder) throws IOException {
        SEMAPHORE.acquireUninterruptibly();
        try {
            int categoryId = 0;
            if (category != null && category.getSelf() instanceof CurseAddon.Category) {
                categoryId = ((CurseAddon.Category)category.getSelf()).getId();
            }
            LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
            query.put("gameId", "432");
            query.put("classId", Integer.toString(this.section));
            if (categoryId != 0) {
                query.put("categoryId", Integer.toString(categoryId));
            }
            query.put("gameVersion", gameVersion);
            query.put("searchFilter", searchFilter);
            query.put("sortField", Integer.toString(this.toModsSearchSortField(sortType)));
            query.put("sortOrder", this.toSortOrder(sortOrder));
            query.put("index", Integer.toString(pageOffset * pageSize));
            query.put("pageSize", Integer.toString(pageSize));
            Response<List<CurseAddon>> response = CurseForgeRemoteModRepository.withApiKey(HttpRequest.GET(downloadProvider.injectURL(NetworkUtils.withQuery("https://api.curseforge.com/v1/mods/search", query)))).getJson(Response.typeOf(JsonUtils.listTypeOf(CurseAddon.class)));
            if (searchFilter.isEmpty()) {
                RemoteModRepository.SearchResult searchResult = new RemoteModRepository.SearchResult(response.getData().stream().map(CurseAddon::toMod), this.calculateTotalPages(response, pageSize));
                return searchResult;
            }
            String lowerCaseSearchFilter = searchFilter.toLowerCase(Locale.ROOT);
            HashMap<String, Integer> searchFilterWords = new HashMap<String, Integer>();
            for (String s : StringUtils.tokenize(lowerCaseSearchFilter)) {
                searchFilterWords.put(s, searchFilterWords.getOrDefault(s, 0) + 1);
            }
            StringUtils.LevCalculator levCalculator = new StringUtils.LevCalculator();
            RemoteModRepository.SearchResult searchResult = new RemoteModRepository.SearchResult(response.getData().stream().map(CurseAddon::toMod).map(remoteMod -> {
                String lowerCaseResult = remoteMod.getTitle().toLowerCase(Locale.ROOT);
                int diff = levCalculator.calc(lowerCaseSearchFilter, lowerCaseResult);
                for (String s : StringUtils.tokenize(lowerCaseResult)) {
                    if (!searchFilterWords.containsKey(s)) continue;
                    diff -= 5 * (Integer)searchFilterWords.get(s) * s.length();
                }
                return Pair.pair(remoteMod, diff);
            }).sorted(Comparator.comparingInt(Pair::getValue)).map(Pair::getKey), response.getData().stream().map(CurseAddon::toMod), this.calculateTotalPages(response, pageSize));
            return searchResult;
        }
        finally {
            SEMAPHORE.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = stream.read(buf, 0, buf.length)) != -1) {
                for (int i = 0; i < len; ++i) {
                    byte b = buf[i];
                    if (b == 9 || b == 10 || b == 13 || b == 32) continue;
                    baos.write(b);
                }
            }
        }
        long hash = Integer.toUnsignedLong(MurmurHash2.hash32(baos.toByteArray(), baos.size(), 1));
        if (hash == 811513880L) {
            return Optional.empty();
        }
        SEMAPHORE.acquireUninterruptibly();
        try {
            Response<FingerprintMatchesResult> response = CurseForgeRemoteModRepository.withApiKey(HttpRequest.POST("https://api.curseforge.com/v1/fingerprints/432")).json(Lang.mapOf(Pair.pair("fingerprints", Collections.singletonList(hash)))).getJson(Response.typeOf(FingerprintMatchesResult.class));
            if (response.getData().getExactMatches() == null || response.getData().getExactMatches().isEmpty()) {
                Optional<RemoteMod.Version> optional = Optional.empty();
                return optional;
            }
            Optional<RemoteMod.Version> optional = Optional.of(response.getData().getExactMatches().get(0).getFile().toVersion());
            return optional;
        }
        finally {
            SEMAPHORE.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteMod getModById(String id) throws IOException {
        SEMAPHORE.acquireUninterruptibly();
        try {
            Response<CurseAddon> response = CurseForgeRemoteModRepository.withApiKey(HttpRequest.GET("https://api.curseforge.com/v1/mods/" + id)).getJson(Response.typeOf(CurseAddon.class));
            RemoteMod remoteMod = ((CurseAddon)response.data).toMod();
            return remoteMod;
        }
        finally {
            SEMAPHORE.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteMod.File getModFile(String modId, String fileId) throws IOException {
        SEMAPHORE.acquireUninterruptibly();
        try {
            Response<CurseAddon.LatestFile> response = CurseForgeRemoteModRepository.withApiKey(HttpRequest.GET(String.format("%s/v1/mods/%s/files/%s", PREFIX, modId, fileId))).getJson(Response.typeOf(CurseAddon.LatestFile.class));
            RemoteMod.File file = response.getData().toVersion().getFile();
            return file;
        }
        finally {
            SEMAPHORE.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
        SEMAPHORE.acquireUninterruptibly();
        try {
            Response<List<CurseAddon.LatestFile>> response = CurseForgeRemoteModRepository.withApiKey(HttpRequest.GET("https://api.curseforge.com/v1/mods/" + id + "/files", Pair.pair("pageSize", "10000"))).getJson(Response.typeOf(JsonUtils.listTypeOf(CurseAddon.LatestFile.class)));
            Stream<RemoteMod.Version> stream = response.getData().stream().map(CurseAddon.LatestFile::toVersion);
            return stream;
        }
        finally {
            SEMAPHORE.release();
        }
    }

    @Override
    public Stream<RemoteModRepository.Category> getCategories() throws IOException {
        SEMAPHORE.acquireUninterruptibly();
        try {
            Response<List<CurseAddon.Category>> categories = CurseForgeRemoteModRepository.withApiKey(HttpRequest.GET("https://api.curseforge.com/v1/categories", Pair.pair("gameId", "432"))).getJson(Response.typeOf(JsonUtils.listTypeOf(CurseAddon.Category.class)));
            Stream<RemoteModRepository.Category> stream = this.reorganizeCategories(categories.getData(), this.section).stream().map(CurseAddon.Category::toCategory);
            return stream;
        }
        finally {
            SEMAPHORE.release();
        }
    }

    private List<CurseAddon.Category> reorganizeCategories(List<CurseAddon.Category> categories, int rootId) {
        ArrayList<CurseAddon.Category> result = new ArrayList<CurseAddon.Category>();
        HashMap<Integer, CurseAddon.Category> categoryMap = new HashMap<Integer, CurseAddon.Category>();
        for (CurseAddon.Category category : categories) {
            categoryMap.put(category.getId(), category);
        }
        for (CurseAddon.Category category : categories) {
            if (category.getParentCategoryId() == rootId) {
                result.add(category);
                continue;
            }
            CurseAddon.Category parentCategory = (CurseAddon.Category)categoryMap.get(category.getParentCategoryId());
            if (parentCategory == null) continue;
            parentCategory.getSubcategories().add(category);
        }
        return result;
    }

    public static class Response<T> {
        private final T data;
        private final Pagination pagination;

        public static <T> TypeToken<Response<T>> typeOf(Class<T> responseType) {
            return TypeToken.getParameterized(Response.class, new Type[]{responseType});
        }

        public static <T> TypeToken<Response<T>> typeOf(TypeToken<T> responseType) {
            return TypeToken.getParameterized(Response.class, new Type[]{responseType.getType()});
        }

        public Response(T data, Pagination pagination) {
            this.data = data;
            this.pagination = pagination;
        }

        public T getData() {
            return this.data;
        }

        public Pagination getPagination() {
            return this.pagination;
        }
    }

    public static class Pagination {
        private final int index;
        private final int pageSize;
        private final int resultCount;
        private final int totalCount;

        public Pagination(int index, int pageSize, int resultCount, int totalCount) {
            this.index = index;
            this.pageSize = pageSize;
            this.resultCount = resultCount;
            this.totalCount = totalCount;
        }

        public int getIndex() {
            return this.index;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public int getResultCount() {
            return this.resultCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }
    }

    private static class FingerprintMatchesResult {
        private final boolean isCacheBuilt;
        private final List<FingerprintMatch> exactMatches;
        private final List<Long> exactFingerprints;

        public FingerprintMatchesResult(boolean isCacheBuilt, List<FingerprintMatch> exactMatches, List<Long> exactFingerprints) {
            this.isCacheBuilt = isCacheBuilt;
            this.exactMatches = exactMatches;
            this.exactFingerprints = exactFingerprints;
        }

        public boolean isCacheBuilt() {
            return this.isCacheBuilt;
        }

        public List<FingerprintMatch> getExactMatches() {
            return this.exactMatches;
        }

        public List<Long> getExactFingerprints() {
            return this.exactFingerprints;
        }
    }

    private static class FingerprintMatch {
        private final int id;
        private final CurseAddon.LatestFile file;
        private final List<CurseAddon.LatestFile> latestFiles;

        public FingerprintMatch(int id, CurseAddon.LatestFile file, List<CurseAddon.LatestFile> latestFiles) {
            this.id = id;
            this.file = file;
            this.latestFiles = latestFiles;
        }

        public int getId() {
            return this.id;
        }

        public CurseAddon.LatestFile getFile() {
            return this.file;
        }

        public List<CurseAddon.LatestFile> getLatestFiles() {
            return this.latestFiles;
        }
    }
}

