/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kala.compress.archivers.zip.ZipArchiveEntry;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.tree.ArchiveFileTree;
import org.jackhuang.hmcl.util.tree.ZipFileTree;

public final class MinecraftInstanceTask<T>
extends Task<ModpackConfiguration<T>> {
    private final Path zipFile;
    private final Charset encoding;
    private final List<String> subDirectories;
    private final Path jsonFile;
    private final T manifest;
    private final String type;
    private final String name;
    private final String version;

    public MinecraftInstanceTask(Path zipFile, Charset encoding, List<String> subDirectories, T manifest, ModpackProvider modpackProvider, String name, String version, Path jsonFile) {
        this.zipFile = zipFile;
        this.encoding = encoding;
        this.subDirectories = subDirectories.stream().map(FileUtils::normalizePath).toList();
        this.manifest = manifest;
        this.jsonFile = jsonFile;
        this.type = modpackProvider.getName();
        this.name = name;
        this.version = version;
    }

    private static void getOverrides(List<ModpackConfiguration.FileInformation> overrides, ZipFileTree tree, ArchiveFileTree.Dir<ZipArchiveEntry> dir, List<String> names) throws IOException {
        Object prefix = String.join((CharSequence)"/", names);
        if (!((String)prefix).isEmpty()) {
            prefix = (String)prefix + "/";
        }
        for (Map.Entry<String, ZipArchiveEntry> entry : dir.getFiles().entrySet()) {
            String hash;
            try (InputStream input = tree.getInputStream(entry.getValue());){
                hash = DigestUtils.digestToString("SHA-1", input);
            }
            overrides.add(new ModpackConfiguration.FileInformation((String)prefix + entry.getKey(), hash));
        }
        for (ArchiveFileTree.Dir dir2 : dir.getSubDirs().values()) {
            names.add(dir2.getName());
            MinecraftInstanceTask.getOverrides(overrides, tree, dir2, names);
            names.remove(names.size() - 1);
        }
    }

    @Override
    public void execute() throws Exception {
        ArrayList<ModpackConfiguration.FileInformation> overrides = new ArrayList<ModpackConfiguration.FileInformation>();
        try (ZipFileTree tree = new ZipFileTree(CompressingUtils.openZipFileWithPossibleEncoding(this.zipFile, this.encoding));){
            for (String subDirectory : this.subDirectories) {
                ArchiveFileTree.Dir<ZipArchiveEntry> root = tree.getDirectory(subDirectory);
                if (root == null) continue;
                ArrayList<String> names = new ArrayList<String>();
                MinecraftInstanceTask.getOverrides(overrides, tree, root, names);
            }
        }
        ModpackConfiguration<T> configuration = new ModpackConfiguration<T>(this.manifest, this.type, this.name, this.version, overrides);
        Files.createDirectories(this.jsonFile.getParent(), new FileAttribute[0]);
        JsonUtils.writeToJsonFile(this.jsonFile, configuration);
        this.setResult(configuration);
    }
}

