/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.util.Log4jLevel;

public final class Log {
    public static final int DEFAULT_LOG_LINES = 2000;
    private final String log;
    private Log4jLevel level;
    private boolean selected = false;

    public static int getLogLines() {
        Integer lines = ConfigHolder.config().getLogLines();
        return lines != null && lines > 0 ? lines : 2000;
    }

    public Log(String log) {
        this.log = log;
    }

    public Log(String log, Log4jLevel level) {
        this.log = log;
        this.level = level;
    }

    public String getLog() {
        return this.log;
    }

    public Log4jLevel getLevel() {
        Log4jLevel level = this.level;
        if (level == null) {
            level = Log4jLevel.guessLevel(this.log);
            if (level == null) {
                level = Log4jLevel.INFO;
            }
            this.level = level;
        }
        return level;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return this.log;
    }
}

