/*
 * Decompiled with CFR 0.152.
 */
package org.hildan.fxgson.factories;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class TypeHelper {
    private TypeHelper() throws InstantiationException {
        throw new InstantiationException("Instances of this type are forbidden.");
    }

    @NotNull
    static TypeToken<?> withRawType(@NotNull TypeToken<?> sourceTypeToken, @NotNull Type newRawType) {
        ParameterizedType sourceType = (ParameterizedType)sourceTypeToken.getType();
        Type[] typeParams = sourceType.getActualTypeArguments();
        ParameterizedType targetType = TypeHelper.newParametrizedType(newRawType, typeParams);
        return TypeToken.get(targetType);
    }

    @NotNull
    private static ParameterizedType newParametrizedType(@NotNull Type rawType, Type ... typeArguments) {
        return new CustomParameterizedType(rawType, null, typeArguments);
    }

    private static class CustomParameterizedType
    implements ParameterizedType {
        private Type rawType;
        private Type ownerType;
        private Type[] typeArguments;

        private CustomParameterizedType(@NotNull Type rawType, @Nullable Type ownerType, Type ... typeArgs) {
            this.rawType = rawType;
            this.ownerType = ownerType;
            this.typeArguments = typeArgs;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }
    }
}

