/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.ReflectionHelper;
import com.jfoenix.adapters.skins.TextFieldSkin;
import com.jfoenix.concurrency.JFXUtilities;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.transitions.CachedTransition;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.transform.Scale;
import javafx.util.Duration;

public class JFXTextFieldSkin
extends TextFieldSkin {
    private boolean invalid = true;
    private StackPane line = new StackPane();
    private StackPane focusedLine = new StackPane();
    private Label errorLabel = new Label();
    private StackPane errorIcon = new StackPane();
    private HBox errorContainer = new HBox();
    private StackPane promptContainer = new StackPane();
    private Text promptText;
    private Pane textPane;
    private ParallelTransition transition;
    private CachedTransition promptTextUpTransition;
    private CachedTransition promptTextDownTransition;
    private CachedTransition promptTextColorTransition;
    private double initScale = 0.05;
    private final Scale promptTextScale = new Scale(1.0, 1.0, 0.0, 0.0);
    private final Scale scale = new Scale(this.initScale, 1.0);
    private Timeline linesAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)this.initScale, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.focusedLine.opacityProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1.0), new KeyValue[]{new KeyValue((WritableValue)this.focusedLine.opacityProperty(), (Object)1, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)this.scale.xProperty(), (Object)1, Interpolator.EASE_BOTH)})});
    private Paint oldPromptTextFill;
    private BooleanBinding usePromptText = Bindings.createBooleanBinding(this::usePromptText, (Observable[])new Observable[]{((TextField)this.getSkinnable()).textProperty(), ((TextField)this.getSkinnable()).promptTextProperty()});
    private final Rectangle errorContainerClip = new Rectangle();
    private final Scale errorClipScale = new Scale(1.0, 0.0, 0.0, 0.0);
    private Timeline errorHideTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)0, Interpolator.LINEAR)})});
    private Timeline errorShowTransition = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)80.0), new KeyValue[]{new KeyValue((WritableValue)this.errorContainer.opacityProperty(), (Object)1, Interpolator.EASE_OUT)})});
    private Timeline scale1 = new Timeline();
    private Timeline scaleLess1 = new Timeline();

    public JFXTextFieldSkin(JFXTextField field) {
        super(field);
        field.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        field.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
        this.errorLabel.getStyleClass().add((Object)"error-label");
        this.line.getStyleClass().add((Object)"input-line");
        this.focusedLine.getStyleClass().add((Object)"input-focused-line");
        this.line.setPrefHeight(1.0);
        this.line.setTranslateY(1.0);
        this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXTextField)this.getSkinnable()).getUnFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        if (((TextField)this.getSkinnable()).isDisabled()) {
            this.line.setBorder(new Border(new BorderStroke[]{new BorderStroke(((JFXTextField)this.getSkinnable()).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(1.0))}));
            this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
        this.focusedLine.setPrefHeight(2.0);
        this.focusedLine.setTranslateY(0.0);
        this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(((JFXTextField)this.getSkinnable()).getFocusColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
        this.focusedLine.setOpacity(0.0);
        this.focusedLine.getTransforms().add((Object)this.scale);
        this.errorContainer.getChildren().setAll((Object[])new Node[]{new StackPane(new Node[]{this.errorLabel}), this.errorIcon});
        this.errorContainer.setAlignment(Pos.CENTER_LEFT);
        this.errorContainer.setSpacing(8.0);
        this.errorContainer.setPadding(new Insets(4.0, 0.0, 0.0, 0.0));
        this.errorContainer.setVisible(false);
        this.errorContainer.setOpacity(0.0);
        this.errorContainer.setManaged(false);
        StackPane.setAlignment((Node)this.errorLabel, (Pos)Pos.TOP_LEFT);
        HBox.setHgrow((Node)this.errorLabel.getParent(), (Priority)Priority.ALWAYS);
        this.errorContainerClip.getTransforms().add((Object)this.errorClipScale);
        this.errorContainer.setClip((Node)(field.isDisableAnimation() != false ? null : this.errorContainerClip));
        this.getChildren().addAll((Object[])new Node[]{this.line, this.focusedLine, this.promptContainer, this.errorContainer});
        field.labelFloatProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                JFXUtilities.runInFX(this::createFloatingLabel);
            } else {
                this.promptText.visibleProperty().bind((ObservableValue)this.usePromptText);
            }
            this.createFocusTransition();
        });
        field.activeValidatorProperty().addListener((o, oldVal, newVal) -> {
            if (this.textPane != null) {
                if (!((JFXTextField)this.getSkinnable()).isDisableAnimation().booleanValue()) {
                    if (newVal != null) {
                        this.errorHideTransition.setOnFinished(finish -> {
                            this.showError((ValidatorBase)((Object)newVal));
                            double w = ((TextField)this.getSkinnable()).getWidth();
                            double errorContainerHeight = this.computeErrorHeight(this.computeErrorWidth(w));
                            if (this.errorLabel.isWrapText()) {
                                if (errorContainerHeight < this.errorContainer.getHeight()) {
                                    this.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{this.createSmallerScaleFrame(errorContainerHeight)});
                                    this.scaleLess1.setOnFinished(event -> {
                                        this.updateErrorContainerSize(w, errorContainerHeight);
                                        this.errorClipScale.setY(1.0);
                                    });
                                    SequentialTransition transition = new SequentialTransition(new Animation[]{this.scaleLess1, this.errorShowTransition});
                                    transition.play();
                                } else {
                                    this.errorClipScale.setY(oldVal == null ? 0.0 : this.errorContainer.getHeight() / errorContainerHeight);
                                    this.updateErrorContainerSize(w, errorContainerHeight);
                                    this.scale1.getKeyFrames().setAll((Object[])new KeyFrame[]{this.createScaleToOneFrames()});
                                    ParallelTransition parallelTransition = new ParallelTransition();
                                    parallelTransition.getChildren().addAll((Object[])new Animation[]{this.scale1, this.errorShowTransition});
                                    parallelTransition.play();
                                }
                            } else {
                                this.errorClipScale.setY(1.0);
                                this.updateErrorContainerSize(w, errorContainerHeight);
                                ParallelTransition parallelTransition = new ParallelTransition(new Animation[]{this.errorShowTransition});
                                parallelTransition.play();
                            }
                        });
                        this.errorHideTransition.play();
                    } else {
                        this.errorHideTransition.setOnFinished(null);
                        if (this.errorLabel.isWrapText()) {
                            this.scaleLess1.getKeyFrames().setAll((Object[])new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                            this.scaleLess1.setOnFinished(event -> {
                                this.hideError();
                                this.errorClipScale.setY(0.0);
                            });
                            SequentialTransition transition = new SequentialTransition(new Animation[]{this.scaleLess1});
                            transition.play();
                        } else {
                            this.errorClipScale.setY(0.0);
                        }
                        this.errorHideTransition.play();
                    }
                } else if (newVal != null) {
                    JFXUtilities.runInFXAndWait(() -> this.showError((ValidatorBase)((Object)newVal)));
                } else {
                    JFXUtilities.runInFXAndWait(this::hideError);
                }
            }
        });
        field.focusColorProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null) {
                this.focusedLine.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newVal, CornerRadii.EMPTY, Insets.EMPTY)}));
                if (((JFXTextField)this.getSkinnable()).isLabelFloat()) {
                    this.promptTextColorTransition = new CachedTransition((Node)this.textPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue(this.promptTextFillProperty2(), newVal, Interpolator.EASE_BOTH)})})){
                        {
                            this.setDelay(Duration.millis((double)0.0));
                            this.setCycleDuration(Duration.millis((double)160.0));
                        }

                        @Override
                        protected void starting() {
                            super.starting();
                            JFXTextFieldSkin.this.oldPromptTextFill = JFXTextFieldSkin.this.getPromptTextFill2();
                        }
                    };
                    this.resetFocusTransition();
                }
            }
        });
        field.unFocusColorProperty().addListener((o, oldVal, newVal) -> {
            if (newVal != null) {
                this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(newVal, CornerRadii.EMPTY, Insets.EMPTY)}));
            }
        });
        field.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.focus();
            } else {
                this.unFocus();
            }
        });
        field.textProperty().addListener((o, oldVal, newVal) -> {
            if (!((TextField)this.getSkinnable()).isFocused() && ((JFXTextField)this.getSkinnable()).isLabelFloat()) {
                if (newVal == null || newVal.isEmpty()) {
                    this.animateFloatingLabel(false);
                } else {
                    this.animateFloatingLabel(true);
                }
            }
        });
        field.disabledProperty().addListener((o, oldVal, newVal) -> {
            this.line.setBorder(newVal != false ? new Border(new BorderStroke[]{new BorderStroke(((JFXTextField)this.getSkinnable()).getUnFocusColor(), BorderStrokeStyle.DASHED, CornerRadii.EMPTY, new BorderWidths(this.line.getHeight()))}) : Border.EMPTY);
            this.line.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(newVal != false ? Color.TRANSPARENT : ((JFXTextField)this.getSkinnable()).getUnFocusColor()), CornerRadii.EMPTY, Insets.EMPTY)}));
        });
        this.promptTextFillProperty2().addListener((o, oldVal, newVal) -> {
            if (Color.TRANSPARENT.equals(newVal) && ((JFXTextField)this.getSkinnable()).isLabelFloat()) {
                this.setPromptTextFill2((Paint)oldVal);
            }
        });
        this.registerChangeListener2((ObservableValue<?>)field.disableAnimationProperty(), "DISABLE_ANIMATION", () -> this.errorContainer.setClip((Node)(((JFXTextField)this.getSkinnable()).isDisableAnimation() != false ? null : this.errorContainerClip)));
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if ((this.transition == null || this.transition.getStatus() == Animation.Status.STOPPED) && ((TextField)this.getSkinnable()).isFocused() && ((JFXTextField)this.getSkinnable()).isLabelFloat()) {
            this.setPromptTextFill2(((JFXTextField)this.getSkinnable()).getFocusColor());
        }
        if (this.invalid) {
            this.invalid = false;
            this.textPane = (Pane)this.getChildren().get(0);
            this.createFloatingLabel();
            ValidatorBase activeValidator = ((JFXTextField)this.getSkinnable()).getActiveValidator();
            if (activeValidator != null) {
                this.showError(activeValidator);
                double errorContainerWidth = w - this.errorIcon.prefWidth(-1.0);
                this.errorContainer.setOpacity(1.0);
                this.errorContainer.resize(w, this.computeErrorHeight(errorContainerWidth));
                this.errorContainerClip.setWidth(w);
                this.errorContainerClip.setHeight(this.errorContainer.getHeight());
                this.errorClipScale.setY(1.0);
            }
            super.layoutChildren(x, y, w, h);
            this.createFocusTransition();
            if (((TextField)this.getSkinnable()).isFocused()) {
                this.focus();
            }
        }
        double height = ((TextField)this.getSkinnable()).getHeight();
        double focusedLineHeight = this.focusedLine.prefHeight(-1.0);
        this.focusedLine.resizeRelocate(x, height, w, focusedLineHeight);
        this.line.resizeRelocate(x, height, w, this.line.prefHeight(-1.0));
        this.errorContainer.relocate(x, height + focusedLineHeight);
        if (((JFXTextField)this.getSkinnable()).isDisableAnimation().booleanValue()) {
            this.errorContainer.resize(w, this.computeErrorHeight(this.computeErrorWidth(w)));
        }
        this.scale.setPivotX(w / 2.0);
    }

    private double computeErrorWidth(double w) {
        return w - this.errorIcon.prefWidth(-1.0);
    }

    private double computeErrorHeight(double errorContainerWidth) {
        return this.errorLabel.prefHeight(errorContainerWidth) + this.errorContainer.snappedBottomInset() + this.errorContainer.snappedTopInset();
    }

    private void updateErrorContainerSize(double w, double errorContainerHeight) {
        this.errorContainerClip.setWidth(w);
        this.errorContainerClip.setHeight(errorContainerHeight);
        this.errorContainer.resize(w, errorContainerHeight);
    }

    private KeyFrame createSmallerScaleFrame(double errorContainerHeight) {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)(errorContainerHeight / this.errorContainer.getHeight()), Interpolator.EASE_BOTH)});
    }

    private KeyFrame createScaleToOneFrames() {
        return new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)this.errorClipScale.yProperty(), (Object)1, Interpolator.EASE_BOTH)});
    }

    private void createFloatingLabel() {
        if (((JFXTextField)this.getSkinnable()).isLabelFloat()) {
            if (this.promptText == null) {
                boolean triggerFloatLabel = false;
                if (this.textPane.getChildren().get(0) instanceof Text) {
                    this.promptText = (Text)this.textPane.getChildren().get(0);
                } else {
                    this.createPromptNode();
                    ReflectionHelper.setFieldContent(TextFieldSkin.class.getSuperclass(), (Object)this, "promptNode", this.promptText);
                    triggerFloatLabel = true;
                }
                this.promptText.getTransforms().add((Object)this.promptTextScale);
                this.promptContainer.getChildren().add((Object)this.promptText);
                if (triggerFloatLabel) {
                    this.promptText.setTranslateY(-this.textPane.getHeight());
                    this.promptTextScale.setX(0.85);
                    this.promptTextScale.setY(0.85);
                }
            }
            this.promptTextUpTransition = new CachedTransition((Node)this.textPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.promptText.translateYProperty(), (Object)(-this.textPane.getHeight()), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.xProperty(), (Object)0.85, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.yProperty(), (Object)0.85, Interpolator.EASE_BOTH)})})){
                {
                    this.setDelay(Duration.millis((double)0.0));
                    this.setCycleDuration(Duration.millis((double)240.0));
                }
            };
            this.promptTextColorTransition = new CachedTransition((Node)this.textPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue(this.promptTextFillProperty2(), (Object)((JFXTextField)this.getSkinnable()).getFocusColor(), Interpolator.EASE_BOTH)})})){
                {
                    this.setDelay(Duration.millis((double)0.0));
                    this.setCycleDuration(Duration.millis((double)160.0));
                }

                @Override
                protected void starting() {
                    super.starting();
                    JFXTextFieldSkin.this.oldPromptTextFill = JFXTextFieldSkin.this.getPromptTextFill2();
                }
            };
            this.promptTextDownTransition = new CachedTransition((Node)this.textPane, new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)1300.0), new KeyValue[]{new KeyValue((WritableValue)this.promptText.translateYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.xProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.promptTextScale.yProperty(), (Object)1, Interpolator.EASE_BOTH)})})){
                {
                    this.setDelay(Duration.millis((double)0.0));
                    this.setCycleDuration(Duration.millis((double)240.0));
                }
            };
            this.promptTextDownTransition.setOnFinished(finish -> {
                this.promptText.setTranslateY(0.0);
                this.promptTextScale.setX(1.0);
                this.promptTextScale.setY(1.0);
            });
            this.promptText.visibleProperty().unbind();
            this.promptText.visibleProperty().set(true);
        }
    }

    private void createPromptNode() {
        this.promptText = new Text();
        this.promptText.setManaged(false);
        this.promptText.getStyleClass().add((Object)"text");
        this.promptText.visibleProperty().bind((ObservableValue)this.usePromptText);
        this.promptText.fontProperty().bind((ObservableValue)((TextField)this.getSkinnable()).fontProperty());
        this.promptText.textProperty().bind((ObservableValue)((TextField)this.getSkinnable()).promptTextProperty());
        this.promptText.fillProperty().bind(this.promptTextFillProperty2());
        this.promptText.setLayoutX(1.0);
    }

    private void focus() {
        if (this.textPane == null) {
            Platform.runLater(this::focus);
        } else {
            if (this.transition == null) {
                this.createFocusTransition();
            }
            this.transition.play();
        }
    }

    private void createFocusTransition() {
        this.transition = new ParallelTransition();
        if (((JFXTextField)this.getSkinnable()).isLabelFloat()) {
            this.transition.getChildren().add((Object)this.promptTextUpTransition);
            this.transition.getChildren().add((Object)this.promptTextColorTransition);
        }
        this.transition.getChildren().add((Object)this.linesAnimation);
    }

    private void unFocus() {
        if (this.transition != null) {
            this.transition.stop();
        }
        this.scale.setX(this.initScale);
        this.focusedLine.setOpacity(0.0);
        if (((JFXTextField)this.getSkinnable()).isLabelFloat() && this.oldPromptTextFill != null) {
            this.setPromptTextFill2(this.oldPromptTextFill);
            if (this.usePromptText()) {
                this.promptTextDownTransition.play();
            }
        }
    }

    private void animateFloatingLabel(boolean up) {
        if (this.promptText == null) {
            Platform.runLater(() -> this.animateFloatingLabel(up));
        } else {
            this.resetFocusTransition();
            if (up && this.promptText.getTranslateY() == 0.0) {
                this.promptTextDownTransition.stop();
                this.promptTextUpTransition.play();
            } else if (!up) {
                this.promptTextUpTransition.stop();
                this.promptTextDownTransition.play();
            }
        }
    }

    private void resetFocusTransition() {
        if (this.transition != null) {
            this.transition.stop();
            this.transition.getChildren().remove((Object)this.promptTextUpTransition);
            this.transition = null;
        }
    }

    private boolean usePromptText() {
        String txt = ((TextField)this.getSkinnable()).getText();
        String promptTxt = ((TextField)this.getSkinnable()).getPromptText();
        return (txt == null || txt.isEmpty()) && promptTxt != null && !promptTxt.isEmpty() && !this.getPromptTextFill2().equals(Color.TRANSPARENT);
    }

    private void showError(ValidatorBase validator) {
        this.errorLabel.setText(validator.getMessage());
        Node icon = validator.getIcon();
        this.errorIcon.getChildren().clear();
        if (icon != null) {
            this.errorIcon.getChildren().setAll((Object[])new Node[]{icon});
            StackPane.setAlignment((Node)icon, (Pos)Pos.CENTER_RIGHT);
        }
        this.errorContainer.setVisible(true);
    }

    private void hideError() {
        this.errorLabel.setText(null);
        this.errorIcon.getChildren().clear();
        this.errorContainer.setVisible(false);
    }
}

