/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls.cells.editors;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.cells.editors.base.EditorNodeBuilder;
import com.jfoenix.validation.DoubleValidator;
import javafx.application.Platform;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;

public class DoubleTextFieldEditorBuilder
implements EditorNodeBuilder<Double> {
    private JFXTextField textField;

    @Override
    public void startEdit() {
        Platform.runLater(() -> {
            this.textField.selectAll();
            this.textField.requestFocus();
        });
    }

    @Override
    public void cancelEdit() {
    }

    @Override
    public void updateItem(Double item, boolean empty) {
        Platform.runLater(() -> {
            this.textField.selectAll();
            this.textField.requestFocus();
        });
    }

    @Override
    public Region createNode(Double value, DoubleBinding minWidthBinding, EventHandler<KeyEvent> keyEventsHandler, ChangeListener<Boolean> focusChangeListener) {
        StackPane pane = new StackPane();
        pane.setStyle("-fx-padding:-10 0 -10 0");
        this.textField = new JFXTextField(value + "");
        this.textField.minWidthProperty().bind((ObservableValue)minWidthBinding);
        this.textField.setOnKeyPressed(keyEventsHandler);
        this.textField.focusedProperty().addListener(focusChangeListener);
        DoubleValidator validator = new DoubleValidator();
        validator.setMessage("Value must be a rational number");
        this.textField.getValidators().add((Object)validator);
        pane.getChildren().add((Object)this.textField);
        return pane;
    }

    @Override
    public void setValue(Double value) {
        this.textField.setText(value + "");
    }

    @Override
    public Double getValue() {
        return Double.parseDouble(this.textField.getText());
    }

    @Override
    public void validateValue() throws Exception {
        if (!this.textField.validate()) {
            throw new Exception();
        }
    }
}

