/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.handler;

import java.util.UUID;
import javax.annotation.Nullable;
import no.jckf.dhsupport.core.DhSupport;
import no.jckf.dhsupport.core.Utils;
import no.jckf.dhsupport.core.bytestream.Decoder;
import no.jckf.dhsupport.core.bytestream.Encoder;
import no.jckf.dhsupport.core.event.EventBus;
import no.jckf.dhsupport.core.message.Message;
import no.jckf.dhsupport.core.message.MessageTypeRegistry;
import no.jckf.dhsupport.core.message.plugin.CancelMessage;
import no.jckf.dhsupport.core.message.plugin.CloseReasonMessage;
import no.jckf.dhsupport.core.message.plugin.ExceptionMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataChunkMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataPartialUpdateMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataSourceRequestMessage;
import no.jckf.dhsupport.core.message.plugin.FullDataSourceResponseMessage;
import no.jckf.dhsupport.core.message.plugin.LevelInitMessage;
import no.jckf.dhsupport.core.message.plugin.PluginMessage;
import no.jckf.dhsupport.core.message.plugin.RemotePlayerConfigMessage;
import no.jckf.dhsupport.core.message.plugin.TrackablePluginMessage;
import org.jetbrains.annotations.NotNull;

public class PluginMessageHandler {
    protected DhSupport dhSupport;
    private MessageTypeRegistry messageTypeRegistry;
    public final String pluginChannel = "distant_horizons:message";
    public final short protocolVersion = (short)11;
    private EventBus<PluginMessage> eventBus;

    public PluginMessageHandler(DhSupport dhSupport) {
        this.dhSupport = dhSupport;
        this.eventBus = new EventBus();
        this.messageTypeRegistry = new MessageTypeRegistry();
        this.messageTypeRegistry.registerMessageType(0, null);
        this.messageTypeRegistry.registerMessageType(1, CloseReasonMessage.class);
        this.messageTypeRegistry.registerMessageType(2, LevelInitMessage.class);
        this.messageTypeRegistry.registerMessageType(3, RemotePlayerConfigMessage.class);
        this.messageTypeRegistry.registerMessageType(4, CancelMessage.class);
        this.messageTypeRegistry.registerMessageType(5, ExceptionMessage.class);
        this.messageTypeRegistry.registerMessageType(6, FullDataSourceRequestMessage.class);
        this.messageTypeRegistry.registerMessageType(7, FullDataSourceResponseMessage.class);
        this.messageTypeRegistry.registerMessageType(8, FullDataPartialUpdateMessage.class);
        this.messageTypeRegistry.registerMessageType(9, FullDataChunkMessage.class);
    }

    public void onEnable() {
    }

    public void onDisable() {
    }

    @Nullable
    public EventBus<PluginMessage> getEventBus() {
        return this.eventBus;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull UUID senderUuid, byte[] data) {
        PluginMessage message;
        try {
            message = this.readPluginMessage(senderUuid, data);
        }
        catch (Exception exception) {
            this.dhSupport.warning("Error while parsing incoming plugin message: " + String.valueOf(exception.getClass()) + " - " + exception.getMessage());
            this.dhSupport.warning("Data was: " + Utils.bytesToHex(data));
            return;
        }
        if (message == null) {
            return;
        }
        message.setSender(senderUuid);
        this.eventBus.dispatch(message);
    }

    protected PluginMessage readPluginMessage(UUID senderUuid, byte[] data) {
        PluginMessage message;
        Decoder decoder = new Decoder(data);
        short protocolVersion = decoder.readShort();
        if (protocolVersion != this.protocolVersion) {
            CloseReasonMessage closeReasonMessage = new CloseReasonMessage();
            closeReasonMessage.setReason((protocolVersion > this.protocolVersion ? "Server" : "Client") + " is outdated.");
            this.sendPluginMessage(senderUuid, closeReasonMessage);
            return null;
        }
        short messageTypeId = decoder.readShort();
        Class<? extends Message> messageClass = this.messageTypeRegistry.getMessageClass(messageTypeId);
        try {
            message = (PluginMessage)messageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (message instanceof TrackablePluginMessage) {
                ((TrackablePluginMessage)message).setTracker(decoder.readInt());
            }
            message.decode(decoder);
        }
        catch (Exception exception) {
            this.dhSupport.warning("Failed to init message class: " + String.valueOf(exception.getClass()) + " - " + exception.getMessage());
            return null;
        }
        return message;
    }

    public void sendPluginMessage(UUID recipientUuid, PluginMessage message) {
        byte[] data;
        Encoder encoder;
        int messageTypeId = this.messageTypeRegistry.getMessageTypeId(message.getClass());
        if (messageTypeId == -1) {
            this.dhSupport.warning("Trying to send unknown message type: " + String.valueOf(message.getClass()));
            return;
        }
        try {
            encoder = new Encoder();
            message.encode(encoder);
            data = encoder.toByteArray();
        }
        catch (Exception exception) {
            this.dhSupport.warning("Failed to encode " + message.getClass().getSimpleName());
            exception.printStackTrace();
            return;
        }
        encoder = new Encoder();
        encoder.writeShort(this.protocolVersion);
        encoder.writeShort(messageTypeId);
        if (message instanceof TrackablePluginMessage) {
            encoder.writeInt(((TrackablePluginMessage)message).getTracker());
        }
        encoder.write(data);
        byte[] fullMessage = encoder.toByteArray();
        this.dhSupport.getPluginMessageSender().sendPluginMessage(recipientUuid, this.pluginChannel, fullMessage);
    }
}

