/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.database.repositories;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Logger;
import no.jckf.dhsupport.core.database.Database;
import no.jckf.dhsupport.core.database.models.LodModel;

public class LodRepository {
    protected static final String SQL_SAVE_LOD = "REPLACE INTO lods (worldId, x, z, data, beacons, timestamp) VALUES (?, ?, ?, ?, ?, ?)";
    protected static final String SQL_LOAD_LOD = "SELECT data, beacons, timestamp FROM lods WHERE worldId = ? AND x = ? AND z = ? LIMIT 1";
    protected static final String SQL_LOD_EXISTS = "SELECT EXISTS( SELECT 1 FROM lods WHERE worldId = ? AND x = ? AND z = ? )";
    protected static final String SQL_DELETE_LOD = "DELETE FROM lods WHERE worldId = ? AND x = ? AND z = ?";
    protected static final String SQL_TRIM_LODS = "DELETE FROM lods WHERE worldId = ? AND (x < ? OR z < ? OR x > ? OR z > ?)";
    protected Database database;
    protected Logger logger;

    public LodRepository(Database database) {
        this.database = database;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LodModel saveLod(UUID worldId, int sectionX, int sectionZ, byte[] data, byte[] beacons) {
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        try {
            PreparedStatement statement = this.database.prepareAndReuse(SQL_SAVE_LOD);
            statement.setString(1, worldId.toString());
            statement.setInt(2, sectionX);
            statement.setInt(3, sectionZ);
            statement.setBytes(4, data);
            statement.setBytes(5, beacons);
            statement.setInt(6, timestamp);
            statement.executeUpdate();
            return LodModel.create().setWorldId(worldId).setX(sectionX).setZ(sectionZ).setData(data).setBeacons(beacons).setTimestamp(timestamp);
        }
        catch (SQLException exception) {
            this.getLogger().warning("Could not save LOD: " + String.valueOf(exception));
            this.database.clearQueryCache();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LodModel loadLod(UUID worldId, int sectionX, int sectionZ) {
        try {
            PreparedStatement statement = this.database.prepareAndReuse(SQL_LOAD_LOD);
            statement.setString(1, worldId.toString());
            statement.setInt(2, sectionX);
            statement.setInt(3, sectionZ);
            try (ResultSet result = statement.executeQuery();){
                byte[] data = result.getBytes("data");
                if (data == null) {
                    LodModel lodModel2 = null;
                    return lodModel2;
                }
                LodModel lodModel = LodModel.create().setWorldId(worldId).setX(sectionX).setZ(sectionZ).setData(data).setBeacons(result.getBytes("beacons")).setTimestamp(result.getInt("timestamp"));
                return lodModel;
            }
        }
        catch (SQLException exception) {
            this.getLogger().warning("Could not load LOD: " + String.valueOf(exception));
            this.database.clearQueryCache();
            return null;
        }
    }

    public boolean lodExists(UUID worldId, int sectionX, int sectionZ) {
        boolean bl;
        block8: {
            PreparedStatement statement = this.database.prepareAndReuse(SQL_LOD_EXISTS);
            statement.setString(1, worldId.toString());
            statement.setInt(2, sectionX);
            statement.setInt(3, sectionZ);
            ResultSet result = statement.executeQuery();
            try {
                boolean bl2 = bl = result.getInt(1) == 1;
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException exception) {
                    this.getLogger().warning("Could not check LOD existence: " + String.valueOf(exception));
                    this.database.clearQueryCache();
                    return false;
                }
            }
            result.close();
        }
        return bl;
    }

    public boolean deleteLod(UUID worldId, int sectionX, int sectionZ) {
        try {
            PreparedStatement statement = this.database.prepareAndReuse(SQL_DELETE_LOD);
            statement.setString(1, worldId.toString());
            statement.setInt(2, sectionX);
            statement.setInt(3, sectionZ);
            int affectedRows = statement.executeUpdate();
            return affectedRows > 0;
        }
        catch (SQLException exception) {
            this.getLogger().warning("Could not delete LOD: " + String.valueOf(exception));
            this.database.clearQueryCache();
            return false;
        }
    }

    public int trimLods(UUID worldId, int lowSectionX, int lowSectionZ, int highSectionX, int highSectionZ) {
        int affectedRows = 0;
        try {
            PreparedStatement statement = this.database.prepareAndReuse(SQL_TRIM_LODS);
            statement.setString(1, worldId.toString());
            statement.setInt(2, lowSectionX);
            statement.setInt(3, lowSectionZ);
            statement.setInt(4, highSectionX);
            statement.setInt(5, highSectionZ);
            affectedRows = statement.executeUpdate();
            this.database.optimize();
        }
        catch (Exception exception) {
            this.getLogger().warning("Could not trim LODs/optimize DB: " + String.valueOf(exception));
        }
        return affectedRows;
    }
}

