/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

public class Configuration {
    protected Map<String, Object> variables = new ConcurrentHashMap<String, Object>();

    public void clear() {
        this.variables.clear();
    }

    public void set(String key, @Nullable Object value) {
        this.variables.put(key, value);
    }

    public void unset(String key) {
        this.variables.remove(key);
    }

    public @PolyNull Object get(String key, @PolyNull Object defaultValue) {
        return this.variables.getOrDefault(key, defaultValue);
    }

    @Nullable
    public Object get(String key) {
        return this.get(key, null);
    }

    public @PolyNull Boolean getBool(String key, @PolyNull Boolean defaultValue) {
        return (Boolean)this.get(key, defaultValue);
    }

    @Nullable
    public Boolean getBool(String key) {
        return this.getBool(key, null);
    }

    public @PolyNull Integer getInt(String key, @PolyNull Integer defaultValue) {
        return (Integer)this.get(key, defaultValue);
    }

    @Nullable
    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public @PolyNull String getString(String key, @PolyNull String defaultValue) {
        Object raw = this.get(key, defaultValue);
        return raw == null ? null : String.valueOf(raw);
    }

    @Nullable
    public String getString(String key) {
        return this.getString(key, null);
    }

    public @PolyNull List<String> getStringList(String key, @PolyNull List<String> defaultValue) {
        return (List)this.get(key, defaultValue);
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, new ArrayList<String>());
    }

    public int increment(String key) {
        return (Integer)this.variables.compute(key, (k, v) -> v == null ? 1 : (Integer)v + 1);
    }
}

