/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.bytestream;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import no.jckf.dhsupport.core.bytestream.Decodable;

public class Decoder {
    protected ByteArrayDataInput input;

    public Decoder(byte[] data) {
        this.input = ByteStreams.newDataInput((byte[])data);
    }

    public byte readByte() {
        return this.input.readByte();
    }

    public boolean readBoolean() {
        return this.input.readBoolean();
    }

    public short readShort() {
        return this.input.readShort();
    }

    public int readInt() {
        return this.input.readInt();
    }

    public long readLong() {
        return this.input.readLong();
    }

    public String readShortString() {
        byte[] chars = new byte[this.input.readShort()];
        this.input.readFully(chars, 0, chars.length);
        return new String(chars, StandardCharsets.UTF_8);
    }

    public String readString() {
        byte[] chars = new byte[this.input.readInt()];
        this.input.readFully(chars, 0, chars.length);
        return new String(chars, StandardCharsets.UTF_8);
    }

    @Nullable
    public <T> T readOptional(Supplier<T> supplier) {
        if (this.readBoolean()) {
            return supplier.get();
        }
        return null;
    }

    @Nullable
    public <T> T readObject(Class<T> className) {
        T instance;
        try {
            instance = className.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
        if (instance instanceof Decodable) {
            ((Decodable)instance).decode(this);
        }
        return instance;
    }

    public <T> Collection<T> readCollection(Class<T> className) {
        int size = this.readInt();
        ArrayList<T> items = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            T item = this.readObject(className);
            items.add(item);
        }
        return items;
    }
}

