/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Locale;

public class Utils {
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);

    public static String bytesToHex(byte[] bytes) {
        byte[] hexChars = new byte[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    public static String bytesToBin(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            builder.append(Integer.toBinaryString(b & 0xFF | 0x100).substring(1));
        }
        return builder.toString().replaceAll("(.{4})", "$1 ").trim();
    }

    public static String ucFirst(String string, Locale locale) {
        if (string.isEmpty()) {
            return "";
        }
        return string.substring(0, 1).toUpperCase(locale) + string.substring(1);
    }

    public static String ucFirst(String string) {
        return Utils.ucFirst(string, Locale.getDefault());
    }

    public static String humanReadableDuration(Duration duration) {
        if (duration.toDays() >= 365L) {
            return "infinite";
        }
        StringBuilder builder = new StringBuilder();
        if (duration.toDays() > 0L) {
            builder.append(duration.toDaysPart()).append(" day");
            if (duration.toDaysPart() != 1L) {
                builder.append("s");
            }
            builder.append(", ");
        }
        if (duration.toHours() > 0L) {
            builder.append(duration.toHoursPart()).append(" hour");
            if (duration.toHoursPart() != 1) {
                builder.append("s");
            }
            builder.append(", ");
        }
        if (duration.toMinutes() > 0L) {
            builder.append(duration.toMinutesPart()).append(" minute");
            if (duration.toMinutesPart() != 1) {
                builder.append("s");
            }
            builder.append(", ");
        }
        if (duration.toSeconds() > 0L || builder.isEmpty()) {
            builder.append(duration.toSecondsPart()).append(" second");
            if (duration.toSecondsPart() != 1) {
                builder.append("s");
            }
            builder.append(", ");
        }
        return builder.substring(0, builder.length() - 2);
    }

    public static String namespaceKey(String key, String defaultNamespace) {
        return key.contains(":") ? key : defaultNamespace + ":" + key;
    }

    public static String namespaceKey(String key) {
        return Utils.namespaceKey(key, "minecraft");
    }

    public static String unNamespaceKey(String key, String namespace) {
        return key.startsWith(namespace + ":") ? key.substring(namespace.length() + 1) : key;
    }

    public static String unNamespaceKey(String key) {
        return Utils.unNamespaceKey(key, "minecraft");
    }
}

