/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core;

import java.util.ArrayList;
import java.util.List;

public class PerformanceTracker {
    private static final int WINDOW_SIZE_MILLIS = 180000;
    private final List<Long> pings = new ArrayList<Long>();

    public synchronized void ping() {
        this.pings.add(System.currentTimeMillis());
    }

    public synchronized void prune() {
        long currentTimeMillis = System.currentTimeMillis();
        this.pings.removeIf(pingTimeMillis -> currentTimeMillis - pingTimeMillis > 180000L);
    }

    public double getPingsPerSecond() {
        if (this.pings.isEmpty()) {
            return 0.0;
        }
        long windowSize = Math.min(180L, System.currentTimeMillis() - this.pings.get(0));
        this.prune();
        return (double)this.pings.size() / (double)windowSize;
    }
}

