/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.bukkit.handler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.jckf.dhsupport.bukkit.BukkitWorldInterface;
import no.jckf.dhsupport.bukkit.DhSupportBukkitPlugin;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;

public class WorldHandler
implements Listener {
    protected static final String[] EVENT_METHOD_NAMES = new String[]{"blockList", "getBlocks", "getBlock"};
    protected DhSupportBukkitPlugin plugin;
    protected Map<String, Method> eventMethods = new HashMap<String, Method>();

    public WorldHandler(DhSupportBukkitPlugin plugin) {
        this.plugin = plugin;
        this.plugin.getServer().getWorlds().forEach(this::addWorldInterface);
        this.registerUpdateListeners();
    }

    protected void addWorldInterface(World world) {
        BukkitWorldInterface worldInterface = new BukkitWorldInterface(this.plugin, world, this.plugin.getDhSupport().getConfig());
        worldInterface.setLogger(this.plugin.getDhSupport().getLogger());
        worldInterface.doUnsafeThings();
        this.plugin.getDhSupport().setWorldInterface(world.getUID(), worldInterface);
    }

    protected void removeWorldInterface(World world) {
        this.plugin.getDhSupport().setWorldInterface(world.getUID(), null);
    }

    protected void touchLod(Location location, String reason) {
        this.plugin.getDhSupport().touchLod(location.getWorld().getUID(), location.getBlockX(), location.getBlockZ(), reason);
    }

    protected void registerUpdateListeners() {
        Listener dummyListener = new Listener(this){};
        for (String eventClassName : this.plugin.getDhSupport().getConfig().getStringList(DhsConfig.UPDATE_EVENTS)) {
            try {
                Class<Event> eventClass = Class.forName(eventClassName).asSubclass(Event.class);
                this.plugin.getServer().getPluginManager().registerEvent(eventClass, dummyListener, EventPriority.MONITOR, (listener, event) -> this.handleUpdateEvent(event), (Plugin)this.plugin);
                this.plugin.getDhSupport().info("Listening for " + eventClassName + ".");
            }
            catch (ClassNotFoundException exception) {
                this.plugin.getDhSupport().warning("Could not find event class: " + eventClassName);
            }
        }
    }

    protected void handleUpdateEvent(Event event) {
        List<Object> list;
        Class<?> eventClass = event.getClass();
        String eventClassName = eventClass.getName();
        Method method = null;
        if (this.eventMethods.containsKey(eventClassName)) {
            method = this.eventMethods.get(eventClassName);
            if (method == null) {
                return;
            }
        } else {
            for (String methodName : EVENT_METHOD_NAMES) {
                try {
                    method = eventClass.getMethod(methodName, new Class[0]);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
            this.eventMethods.put(eventClassName, method);
            if (method == null) {
                this.plugin.getDhSupport().warning("Unsure how to handle event: " + eventClass.getName());
                return;
            }
        }
        try {
            Object result = method.invoke((Object)event, new Object[0]);
            list = result instanceof List ? (List<Object>)result : List.of(result);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
        for (Object entry : list) {
            if (entry instanceof Block) {
                Block block = (Block)entry;
                this.touchLod(block.getLocation(), eventClassName);
                continue;
            }
            if (entry instanceof BlockState) {
                BlockState state = (BlockState)entry;
                this.touchLod(state.getLocation(), eventClassName);
                continue;
            }
            this.plugin.getDhSupport().warning("Unknown block " + String.valueOf(entry) + " from event: " + eventClassName);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent worldLoad) {
        this.addWorldInterface(worldLoad.getWorld());
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent worldUnload) {
        this.removeWorldInterface(worldUnload.getWorld());
    }
}

