/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.bukkit;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import no.jckf.dhsupport.bukkit.DhSupportBukkitPlugin;
import no.jckf.dhsupport.core.Utils;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.scheduling.Scheduler;
import no.jckf.dhsupport.folialib.FoliaLib;
import org.bukkit.Location;

public class BukkitScheduler
implements Scheduler {
    protected DhSupportBukkitPlugin plugin;
    protected FoliaLib foliaLib;
    protected ExecutorService executor;

    public BukkitScheduler(DhSupportBukkitPlugin plugin) {
        this.plugin = plugin;
        this.foliaLib = new FoliaLib(this.plugin);
        int threadCount = this.plugin.getDhSupport().getConfig().getInt(DhsConfig.SCHEDULER_THREADS);
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
        this.plugin.getDhSupport().info("Using " + Utils.ucFirst(this.foliaLib.getImplType().name().toLowerCase().replace('_', ' ')) + " scheduler.");
    }

    @Override
    public boolean canReadWorldAsync() {
        return !this.foliaLib.isFolia();
    }

    @Override
    public <U> CompletableFuture<U> runOnMainThread(Supplier<U> supplier) {
        CompletableFuture future = new CompletableFuture();
        if (this.foliaLib.getScheduler().isGlobalTickThread()) {
            future.complete(supplier.get());
        } else {
            this.foliaLib.getScheduler().runNextTick(task -> {
                try {
                    future.complete(supplier.get());
                }
                catch (Exception exception) {
                    future.completeExceptionally(exception);
                }
            });
        }
        return future;
    }

    @Override
    public <U> CompletableFuture<U> runOnRegionThread(UUID worldId, int x, int z, Supplier<U> supplier) {
        CompletableFuture future = new CompletableFuture();
        Location location = new Location(this.plugin.getServer().getWorld(worldId), (double)x, 0.0, (double)z);
        if (this.foliaLib.getScheduler().isOwnedByCurrentRegion(location)) {
            future.complete(supplier.get());
        } else {
            this.foliaLib.getScheduler().runAtLocation(location, task -> {
                try {
                    future.complete(supplier.get());
                }
                catch (Exception exception) {
                    future.completeExceptionally(exception);
                }
            });
        }
        return future;
    }

    @Override
    public <U> CompletableFuture<U> runOnSeparateThread(Supplier<U> supplier) {
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> {
            try {
                future.complete(supplier.get());
            }
            catch (Exception exception) {
                future.completeExceptionally(exception);
            }
        });
        return future;
    }

    @Override
    public void cancelTasks() {
        this.executor.shutdown();
        this.foliaLib.getScheduler().cancelAllTasks();
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void runTimer(Runnable runnable, long initialDelay, long interval) {
        this.foliaLib.getScheduler().runTimer(runnable, initialDelay, interval);
    }
}

